{% set unit = 'yandex-yasmagent' %}

{% for file in pillar.get(unit + '-config-files', []) %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get(unit + '-exec-files', []) %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 755 
    - user: root
    - group: root
    - makedirs: True
    - template: jinja
    - context:
      loggiver_port: {{ pillar.get('loggiver_port', 3132) }}
{% endfor %}

yandex-yasmagent:
  pkg:
    - installed

python3:
  pkg:
    - installed