#!/bin/sh

me=${0##*/}     # strip path
me=${me%.*}     # strip extension
day=5

die() {
    echo "PASSIVE-CHECK:$me;$1;$2"
    exit 0
}

check_date() {
    ctime=$(date +%s) # current time
    mtime=$(docker exec yavs cat /var/lib/yandex/yavs-vdb-full/vdb.xml 2>/dev/null| xmlstarlet sel -t -v '/vdbCollection/vdbList/vdbVersion/@time' 2>/dev/null)
    ltime=$(( $ctime - $mtime - $1 * 86400 )) # limit time

    if [ -z "$mtime" ] ; then
       die 2  "File not exists"
    fi

    if [ $ltime -le 0 ]; then
        die 0 "OK! Virus base updated less than $1 days ago"
    else
        die 2  "Too old virus base ($1 days)"
    fi
}

check_date $day
