{% set cluster = pillar.get('cluster') %}
{% set unit = 'yavs-docker' %}

{% for file in pillar.get(unit + '-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get(unit + '-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

/etc/sudoers.d/monrun_yavs:
  yafile.managed:
    - source: salt://units/{{ unit }}/files/etc/sudoers.d/monrun_yavs
    - mode: 640
    - user: root
    - group: root

/var/log/yavs/yascand:
  file.directory:
    - user: 105
    - group: 109
    - mode: 755
    - makedirs: True
    - require_in:
      - yavs-docker

/var/log/yavs/c-icap:
  file.directory:
    - user: 105
    - group: 109
    - mode: 755
    - makedirs: True
    - require_in:
      - yavs-docker

prereq.packages:
  pkg.installed:
    - pkgs:
      - apt-transport-https
      - python-pip
      - python-setuptools
      - xmlstarlet

prereq.pip:
  pip.installed:
    - names:
      - requests==2.27.1
    - require:
      - pkg: prereq.packages
    - index_url: https://pypi.yandex-team.ru/simple/
 
docker.repo:
  pkgrepo.managed:
    - require:
      - /etc/apt/apt.conf.d/01-dist-https
    - require_in:
      - pkg: docker.installed
    - humanname: docker
    - name: deb [arch=amd64] https://download.docker.com/linux/ubuntu trusty stable
    - file: /etc/apt/sources.list.d/docker.list
    - key_url: salt://units/{{ unit }}/0EBFCD88.asc
    - refresh_db: true

docker.installed:
  pkg.installed:
    - name: docker-ce
    - require:
      - /etc/docker/daemon.json
      - pkg: docker.removed

docker.removed:
  pkg.removed:
    - name: docker.io

docker-py:
  pip.installed:
    - names:
      - websocket-client==0.57.0
      - docker==4.2.0
    - require:
      - pkg: prereq.packages
      - pkg: docker.installed
      - pip: prereq.pip
    - require_in:
      - yavs-docker
    - reload_modules: true
    - index_url: https://pypi.yandex-team.ru/simple/

docker.login:
  cmd.run:
    - name: docker login -u {{ salt['pillar.get']('docker-registries:registry.yandex.net:username') }} -p {{ salt['pillar.get']('docker-registries:registry.yandex.net:password') }} registry.yandex.net
    - require_in:
      - yavs-docker

yavs-docker:
  docker_container.running:
    - name: yavs
    - image: {{ salt['pillar.get']('yavs:image') }}
    - restart: unless-stopped
    - start: True
    - network_mode: host
    - binds: /var/log/yavs/c-icap/:/var/log/c-icap:rw,/var/log/yavs/yascand/:/var/log/yascand:rw
    - environment:
      - VIRLAB_SOLOMON_OAUTH: {{ salt['pillar.get']('yavs:VIRLAB_SOLOMON_OAUTH') }}
