#!/bin/bash

KEEP_BACKUPS=48
DST_PATH='/var/backups/git'
DATE=$(date "+%Y-%m-%d.%H-00")

do_backup(){
    local dst=$1
    tar --ignore-failed-read -czf ${dst} -C / srv
}

remove_old(){
    local path=$1 keep=$2
    remove_list=$(ls --sort=time -1 ${path} | tail -n +${keep})
    test -z "${remove_list}" && return 0
    for file in ${remove_list}
    do
        rm -f ${path}/${file}
    done
}

mkdir -p ${DST_PATH}
do_backup ${DST_PATH}/${DATE}.tar.gz && \
    remove_old ${DST_PATH} ${KEEP_BACKUPS}
