# -*- coding: utf-8 -*-
"""
A module that adds data to the Pillar structure retrieved by an http request to pgaas deploy api


Configuring the pgaas_deploy ext_pillar
=======================================

Set the following Salt config to setup pgaas_deploy as external pillar source:

.. code-block:: yaml

  ext_pillar:
    - pgaas_deploy:
        url: https://pgaas-slb/pgaas/1.0/deploy/minion_id
        token: <Internal OAuth token>

"""
from __future__ import absolute_import

import fnmatch
import logging
import json
import requests


def ext_pillar(minion_id,
               pillar,
               url='http://localhost/',
               include_only=[],
               token=''):
    """
    Read pillar data from HTTP response.

    :param url String to make request
    :param token String OAuth token
    :returns dict with pillar data to add
    :returns empty if error
    """
    log = logging.getLogger(__name__)

    if include_only:
        match = False

        for i in include_only:
            if fnmatch.fnmatch(minion_id, i):
                match = True
                break
    else:
        match = True

    if not match:
        return {}

    try:
        ret = requests.get(url + minion_id, verify=False, headers={'Authorization': 'OAuth ' + token}).json()
        try:
            with open('/dev/shm/' + minion_id, 'w') as f:
                f.write(json.dumps(ret))
        except Exception:
            pass
        return ret
    except Exception as e:
        log.error(e)
        ret = {}
        try:
            with open('/dev/shm/' + minion_id) as f:
                ret = json.loads(f.read())
        except Exception:
            pass
        return ret
