#!/usr/bin/env python
# encoding: utf-8

from __future__ import absolute_import, print_function, unicode_literals

import argparse
import os

import yaml

import git

parser = argparse.ArgumentParser()

parser.add_argument('-e', '--environment',
                    type=str,
                    default=None,
                    help='Show only environment')

args = parser.parse_args()

with open('/srv/conf/master') as f:
    srv_conf = yaml.load(f.read())

repos = {}

for i in srv_conf['gitfs_remotes']:
    remote_conf = i[i.keys()[0]][0]
    if 'root' in remote_conf:
        path = '/srv'
        repos[path] = git.Repo(path)
    elif 'mountpoint' in remote_conf:
        path = os.path.join('/srv',
                            remote_conf['mountpoint'].replace(':/', ''))
        repos[path] = git.Repo(path)

with open('/srv/pillar/versions.sls') as f:
    versions = yaml.load(f.read())

status = {}
synced = {}

for env in versions:
    if env == 'base':
        continue

    if args.environment is not None and env != args.environment:
        continue

    status[env] = {}
    synced[env] = {}

    for path in versions[env]:
        if path == 'components':
            continue
        rev = str(versions[env][path])
        if rev == 'master':
            continue
        full_path = os.path.join('/srv/salt', path)
        for r in sorted(repos.keys(), key=len, reverse=True):
            if full_path.startswith(r):
                sync = False
                if rev == 'master':
                    sync = True
                else:
                    diff = repos[r].git.log('--graph',
                                            "--pretty=%Cred%h%Creset " +
                                            "-%C(yellow)%d%Creset %s " +
                                            "%Cgreen(%cr) %C(bold " +
                                            "blue)<%an>%Creset",
                                            '--date=relative',
                                            rev + '..' +
                                            repos[r].head.object.hexsha,
                                            '--',
                                            os.path.relpath(full_path, r))
                    if diff:
                        status[env][full_path] = []
                        for l in diff.decode('utf-8').split('\n'):
                            status[env][full_path].append(l.rstrip())
                    else:
                        sync = True
                if sync:
                    hist = repos[r].git.log('--graph',
                                            "--pretty=%Cred%h%Creset " +
                                            "-%C(yellow)%d%Creset %s " +
                                            "%Cgreen(%cr) %C(bold " +
                                            "blue)<%an>%Creset",
                                            '--date=relative',
                                            '--',
                                            os.path.relpath(full_path, r))
                    synced[env][full_path] = []
                    for l in hist.split('\n'):
                        synced[env][full_path].append(l.rstrip())
                break

for env in status:
    print(env + ':')
    for path in sorted(status[env]):
        exclude = set()
        for opath in status[env]:
            if path != opath and opath.startswith(path):
                for l in status[env][opath]:
                    exclude.add(l)
        for opath in synced[env]:
            if path != opath and opath.startswith(path):
                for l in synced[env][opath]:
                    exclude.add(l)
        out = [x for x in status[env][path] if x not in exclude]
        if out:
            print('   ', path)
            for l in out:
                print('       ', l.encode('utf-8'))
