mine_functions:
    grains.item:
        - id
        - role
        - ya
        - pg
        - virtual

data:
    condgroup: disk_commentsdb
    runlist:
        - components.postgres
        - components.pg-dbs.commentsdb
        - components.pg-dbs.disksubsdb
        - components.pg-dbs.urlsdb
        - components.pg-dbs.comments_metadb
        - components.monrun2.disk
        - components.hw-watcher
    dbname: commentsdb
    config:
        min_wal_size: 8GB
        max_wal_size: 32GB
        checkpoint_timeout: 30min
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
        log_min_duration_statement: 100ms
        effective_cache_size: 100GB
        lock_timeout: 2s
        autovacuum_vacuum_cost_delay: 10ms
        autovacuum_vacuum_cost_limit: 1000
        pool_mode: transaction
        server_reset_query: 'DISCARD ALL'
        server_reset_query_always: 1
        log_keep_days: 7
        application_name_add_host: 0
    pgbouncer:
        count: 8
        internal_count: 2
        log_connections: 0
        log_disconnections: 0
    sysctl:
        vm.swappiness: 0
        vm.nr_hugepages: 2500
    l3host: True
    ipv6selfdns: True
    network_autoconf: True
    monrun2: True
    monrun:
        unispace:
            warn: 80
            crit: 90
            repack: 95
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    use_walg: True
    use_wale: False
    use_barman: False
    s3_bucket: 'disk-backup-pg'
    walg:
        backup_keep: 21
        delta_max_steps: 2
        compression_method: brotli
    ship_logs: True

gpg-yav-secrets: {{ salt.yav.get('sec-01d4wfkc3x2vherrkrf00gf52c') | json }}

include:
    - disk_pgsync_conf
    - disk_logrotate_conf
    - index_repack
    - envs.prod
    - private.pg.users.prod.common
    - private.pg.users.prod.comments
    - private.pg.users.prod.disksubs
    - private.pg.users.prod.disk_lenta_loader
    - private.pg.tls.prod
    - private.pg.barman.pg2barman.prod.keys
    - private.pg.users.prod.disk_urls
    - private.selfdns.realm-disk
    - private.s3.prod.disk_s3backup
    - private.abyssync.prod.disk
    - private.push-client.prod.disk
