mine_functions:
    grains.item:
        - id
        - role
        - ya
        - pg

data:
    condgroup: disk_common_db
    runlist:
        - components.postgres
        - components.pg-dbs.disk_commondb
        - components.monrun2.disk
        - components.hw-watcher
    dbname: disk_commondb
    config:
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
        log_min_duration_statement: 1000ms
        pool_mode: transaction
        wal_log_hints: 'on'
        auto_kill_timeout: 2 hours
        max_client_pool_conn: 22000
        max_client_conn: 28000
        pg_stat_ucache.max: 100000
        lock_timeout: 2s
        log_rotate_by_size: True
        autovacuum_vacuum_cost_limit: 3000
        autovacuum_vacuum_cost_delay: 7ms
        archive_timeout: 60
    monrun:
        load_average_relative:
            warn: 2
            crit: 4
        unispace:
            warn: 80
            crit: 90
            repack: 95
        pg_vacuum:
            warn: 21600
            crit: 43200
        pg_vacuum_failure:
            crit: 2
        free_space_trend:
            skip_root: True
    monrun2: True
    disk_commondb:
        target: 0016
    pg:
        version:
          major_num: 1000
    pgbouncer:
        count: 8
        internal_count: 2
        log_connections: 0
        log_disconnections: 0
    l3host: True
    network_autoconf: True
    add_to_sharpei: True
    sharpei_condgroup: disk_sharpei_mpfs
    sharpei_balancer: mpfs-sharpei.disk.yandex.net
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    backup:
        archive:
            bwlimit: 50000
    yt:
        ucache: True
    yasmagent:
        prj_split_by_shard: False
    use_walg: True
    use_wale: False
    use_barman: False
    s3_bucket: 'disk-backup-pg'
    walg:
        backup_keep: 30
        delta_max_steps: 1
        compression_method: brotli
    index_repack:
        bytes_min: 2000000000
        perc_min: 30
    ship_logs: True
    pgsync:
        overload_sessions_ratio: 20
    juggler:
        namespace: disk-mpfs-db
    auto_resetup: True

gpg-yav-secrets: {{ salt.yav.get('sec-01e20ss9d6yvzyf9wkahxhe8pz') | json }}

include:
    - disk_pgsync_conf
    - disk_logrotate_conf
    - index_repack
    - envs.prod
    - private.pg.users.prod.common
    - private.pg.users.prod.disk_commondb
    - private.pg.users.prod.disk_sharpei_mpfs
    - private.pg.tls.prod
    - private.pg.barman.pg2barman.prod.keys
    - private.selfdns.realm-disk
    - private.yt.mpfs_tokens
    - private.s3.prod.disk_s3backup
    - private.abyssync.prod.disk
    - private.push-client.prod.disk
