mine_functions:
    grains.item:
        - id
        - role
        - ya
        - pg
        - virtual

data:
    l3host: True
    network_autoconf: True
    add_to_sharpei: True
    runlist:
        - components.postgres
        - components.pg-dbs.apidb
        - components.monrun2.disk
        - components.hw-watcher
    dbname: api_disk_data
    conf:
        porto_attacher:
            io_limit: 157286400
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    config:
        min_wal_size: 8GB
        max_wal_size: 128GB
        checkpoint_timeout: 30min
        checkpoint_completion_target: 0.9
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
        effective_cache_size: 100GB
        lock_timeout: 2s
        log_min_duration_statement: 100ms
        autovacuum_vacuum_cost_limit: 1000
        autovacuum_vacuum_cost_delay: 10
        pool_mode: transaction
        server_reset_query: 'DISCARD ALL'
        server_reset_query_always: 1
        log_keep_days: 7
        application_name_add_host: 0
        max_client_pool_conn: 8000
        pg_stat_ucache.max: 100
        log_rotate_by_size: True
        archive_timeout: 60
    pgbouncer:
        count: 8
        internal_count: 2
        log_connections: 0
        log_disconnections: 0
    monrun:
        pg_replication_lag:
            crit: 600
        pg_log_errors:
            warn: '500\ 100'
            exclude: '"lenta_loader.*could not obtain lock on row in relation\|duplicate key value violates unique constraint"'
        unispace:
            warn: 80
            crit: 90
            repack: 95
        pg_vacuum:
            warn: 43200
            crit: 129600
        pg_vacuum_failure:
            crit: 10
    monrun2: True
    yasmagent:
        prj_split_by_shard: False
    backup:
        archive:
            bwlimit: 20000
    ship_logs: True

    sharpei_condgroup: disk_sharpei_dapi
    sharpei_balancer: dapi-sharpei.disk.yandex.net
    yt:
        ucache: False
    s3_bucket: 'disk-backup-pg'
    walg:
        backup_keep: 21
        delta_max_steps: 5
        compression_method: brotli
        cron:
            minute: {{ salt['random.seed'](59, hash=salt['grains.get']('id').split('.')[0][:-1]) }}
            hour: {{ salt['random.seed'](7, hash=salt['grains.get']('id').split('.')[0][:-1]) }}
    use_walg: True
    use_wale: False
    use_barman: False
    auto_resetup: True
    index_repack:
        bytes_min: 300000000
        perc_min: 30


include:
    - disk_dataapi_db.{{ salt['grains.get']('id').split('.')[0][:-1] }}
    - disk_pgsync_conf
    - disk_logrotate_conf
    - index_repack
    - envs.prod
    - private.pg.barman.pg2barman.prod.keys
    - private.pg.tls.prod
    - private.pg.users.prod.common
    - private.pg.users.prod.dataapi
    - private.pg.users.prod.disk_lenta_loader
    - private.pg.users.prod.disk_notification_center
    - private.pg.users.prod.disk_sharpei_dapi
    - private.push-client.prod.disk
    - private.s3.prod.disk_s3backup
    - private.selfdns.realm-disk
    - private.abyssync.prod.disk
    - private.yt.tokens
