mine_functions:
    grains.item:
        - id
        - role
        - ya
        - pg
        - virtual

data:
    condgroup: disk_diskq_db
    readahead_buffer_bytes:
        md2: 32
    runlist:
        - components.postgres
        - components.pg-dbs.diskqdb
        - components.monrun2.disk
        - components.hw-watcher
        - components.yandex-lazy-trim
    dbname: diskqdb
    update_job_counters_limit: 50000
    update_job_counters_threads: 2
    config:
        min_wal_size: 8GB
        max_wal_size: 128GB
        checkpoint_timeout: 20min
        checkpoint_completion_target: 0.9
        log_min_duration_statement: 1000ms
        autovacuum_analyze_scale_factor: '0.00001'
        default_statistics_target: '1000'
        autovacuum_vacuum_cost_limit: 7000
        autovacuum_vacuum_cost_delay: 5
        lock_timeout: 2s
        pool_mode: transaction
        server_reset_query: 'DISCARD ALL'
        server_reset_query_always: 1
        log_keep_days: 7
        application_name_add_host: 0
        max_client_pool_conn: 8000
        log_rotate_by_size: True
        effective_cache_size: 100GB
{% if salt['grains.get']('pg:suffix') == 'qdb01' %}
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
    pgbouncer:
        count: 16
        internal_count: 4
{% else %}
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
    pgbouncer:
        count: 8
        internal_count: 1
{% endif %}
        log_connections: 0
        log_disconnections: 0
    backup:
        archive:
            bwlimit: 20000
    sysctl:
        vm.swappiness: 0
        vm.nr_hugepages: 4500
    l3host: True
    network_autoconf: True
    monrun:
        pg_replication_lag:
            crit: 600
        pg_log_errors:
            warn: '500\ 100'
            exclude: '"data was relocated to shard"'
        unispace:
            warn: 80
            crit: 90
            repack: 95
        pg_vacuum_failure:
            crit: 300
    monrun2: True
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    yasmagent:
        prj_split_by_shard: False
    pg:
        version:
          major_num: 1000
    s3_bucket: 'disk-backup-pg'
    use_wale: False
    walg:
        backup_keep: 5
        delta_max_steps: 0
        compression_method: brotli
    ship_logs: True
    diskqdb:
        target: 0023

include:
    - disk_diskq_db.{{ salt['grains.get']('id').split('.')[0][:-1] }}
    - index_repack
    - disk_pgsync_conf
    - disk_logrotate_conf
    - envs.prod
    - private.pg.users.prod.common
    - private.pg.users.prod.diskq
    - private.pg.users.prod.disk_lenta_loader
    - private.pg.users.prod.disk_notification_center
    - private.pg.tls.prod
    - private.pg.barman.pg2barman.prod.keys
    - private.selfdns.realm-disk
    - private.s3.prod.disk_s3backup
    - private.abyssync.prod.disk
    - private.push-client.prod.disk
