mine_functions:
    grains.item:
        - id
        - role
        - ya
        - pg

data:
    runlist:
        - components.postgres
        - components.pg-dbs.diskdb.prod
        - components.monrun2.disk
        - components.hw-watcher
    dbname: diskdb
    config:
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
        log_min_duration_statement: 1000ms
        pool_mode: transaction
        wal_log_hints: 'on'
        auto_kill_timeout: 2 hours
        max_client_pool_conn: 22000
        max_client_conn: 28000
        pg_stat_ucache.max: 100000
        lock_timeout: 2s
        log_rotate_by_size: True
        autovacuum_vacuum_cost_limit: 3500
        autovacuum_vacuum_cost_delay: 5ms
        archive_timeout: 60
        idle_in_transaction_session_timeout: 10800000
    monrun:
        load_average_relative:
            warn: 2
            crit: 4
        unispace:
            warn: 80
            crit: 90
            repack: 95
        pg_vacuum:
            warn: 21600
            crit: 50000
        pg_vacuum_failure:
            crit: 5
        free_space_trend:
            skip_root: True
    monrun2: True
    diskdb:
        target: 0111
    pgbouncer:
        count: 8
        internal_count: 2
        log_connections: 0
        log_disconnections: 0
    l3host: True
    network_autoconf: True
    add_to_sharpei: True
    sharpei_condgroup: disk_sharpei_mpfs
    sharpei_balancer: mpfs-sharpei.disk.yandex.net
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    backup:
        archive:
            bwlimit: 50000
    yt:
        ucache: True
    yasmagent:
        prj_split_by_shard: False
    s3_bucket: 'disk-backup-pg'
    use_wale: False
    walg:
        backup_keep: 30
        delta_max_steps: 5
        cron:
            minute: {{ salt['random.seed'](59, hash=salt['grains.get']('id').split('.')[0][:-1]) }}
            hour: {{ salt['random.seed'](5, hash=salt['grains.get']('id').split('.')[0][:-1]) }}
        compression_method: brotli
    index_repack:
        bytes_min: 1500000000
        perc_min: 25
        except_obj_list: ix_files_date_hidden_data
    ship_logs: True
    pgsync:
        overload_sessions_ratio: 20
    juggler:
        namespace: disk-mpfs-db
    use_walg: True
    use_barman: False
    auto_resetup: True
    dump_yt:
        tables: disk.storage_files:storage_id
        yt_prefix: //home/mpfs-stat/storage/mpfs_db_dump/
        cron: "40 23 10 8 *"

include:
    - disk_mpfs_db.{{ salt['grains.get']('id').split('.')[0][:-1] }}
    - envs.prod
    - disk_pgsync_conf
    - disk_logrotate_conf
    - index_repack
    - private.pg.users.prod.common
    - private.pg.users.prod.djfs
    - private.pg.users.prod.disk_mpfs
    - private.pg.users.prod.disk_mworker
    - private.pg.users.prod.disk_pworker
    - private.pg.users.prod.disk_sharpei_mpfs
    - private.pg.tls.prod
    - private.pg.barman.pg2barman.prod.keys
    - private.selfdns.realm-disk
    - private.yt.mpfs_tokens
    - private.s3.prod.disk_s3backup
    - private.abyssync.prod.disk
    - private.push-client.prod.disk
