mine_functions:
    grains.item:
        - id
        - role
        - ya
        - pg
        - virtual

data:
    ps_billing_db:
        target: 0371
    condgroup: disk_ps_billing_db
    runlist:
        - components.postgres
        - components.pg-dbs.ps_billing_db
        - components.pg-dbs.ps_billing_db.prod
        - components.monrun2.disk
        - components.hw-watcher
    dbname: ps_billing_db
    config:
        min_wal_size: 8GB
        max_wal_size: 32GB
        checkpoint_timeout: 30min
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
        log_min_duration_statement: 100ms
        effective_cache_size: 100GB
        lock_timeout: 2s
        autovacuum_vacuum_cost_delay: 10ms
        autovacuum_vacuum_cost_limit: 1000
        pool_mode: transaction
        server_reset_query: 'DISCARD ALL'
        server_reset_query_always: 1
        log_keep_days: 7
        application_name_add_host: 0
        archive_timeout: 60
    pgbouncer:
        count: 8
        internal_count: 2
        log_connections: 0
        log_disconnections: 0
    sysctl:
        vm.swappiness: 0
        vm.nr_hugepages: 2500
    l3host: True
    ipv6selfdns: True
    network_autoconf: True
    monrun2: True
    monrun:
        unispace:
            warn: 80
            crit: 90
            repack: 95
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    use_walg: True
    use_wale: False
    use_barman: False
    s3_bucket: 'disk-backup-pg'
    walg:
        backup_keep: 21
        delta_max_steps: 1
        compression_method: brotli
        auto_resetup: True
    ship_logs: True
    pg:
      version:
        major_num: 1000
    dump_yt:
        tables: groups:created_at,group_services:created_at,group_service_members:created_at,accepted_agreements:group_id,group_trust_payment_requests:created_at,group_products:created_at,user_services:created_at,user_products:created_at,group_service_transaction_calculations:billing_date,group_service_transactions:id,group_service_price_overrides:created_at,trial_usage:created_at,promo_templates:created_at,user_promos:created_at,refunds:created_at,orders:created_at,inapp_migrations:created_at
        yt_prefix: //home/disk-ps-billing/db_dump/
        cron: "0 1 * * *"

gpg-yav-secrets: {{ salt.yav.get('sec-01dw9mea851j9s52ky62ax3ga1') | json }}

include:
    - disk_pgsync_conf
    - disk_logrotate_conf
    - index_repack
    - envs.prod
    - private.pg.users.prod.common
    - private.pg.users.prod.ps_billing
    - private.pg.tls.prod
    - private.pg.barman.pg2barman.prod.keys
    - private.selfdns.realm-disk
    - private.s3.prod.disk_s3backup
    - private.yt.ps_billing_tokens
    - private.abyssync.prod.disk
    - private.push-client.prod.disk
