mine_functions:
    grains.item:
        - id
        - role
        - ya
        - pg
        - virtual

{% set shard = salt['grains.get']('id').split('.')[0][-3:-1] %}
{% if shard == '02' %}
{%     set pg_master = salt['grains.get']('id').replace(shard, '01') %}
pg-master: {{ pg_master }}
{% elif shard not in ['01', '02'] %}
{%     set pg_master = salt['grains.get']('id').replace(shard, '02') %}
pg-master: {{ pg_master }}
{% endif %}

data:
    condgroup: disk_sharpei_datasync
    runlist:
        - components.postgres
        - components.pg-dbs.sharddb
        - components.sharpei
        - components.monrun2.disk
        - components.push-client
    sharpei:
        cascade: True
        flavor: datasync
        zk_hosts: zk-pgsync01e.disk.yandex.net:2181,zk-pgsync01f.disk.yandex.net:2181,zk-pgsync01h.disk.yandex.net:2181,zk-pgsync01v.disk.yandex.net:2181
        nginx:
            tskv_format: ydisk-nginx-access-log-sharpei-datasync
    yasmagent:
        prj_split_by_shard: False
        sysconfig_pkg: sharpei
        instances:
            - mailpostgresql
            - mailsharpei
    dbname: sharddb
    separate_array_for_xlogs: False
    config:
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
        log_min_duration_statement: 100ms
        pool_mode: transaction
        wal_log_hints: 'on'
        auto_kill_timeout: 2 hours
        max_prepared_transactions: 1000
        log_rotate_by_size: True
        archive_timeout: 60
    pgsync:
{% if shard != '01' %}
        replication_source: {{ pg_master }}
{% endif %}
        zk_lockpath_prefix: /pgsync/ds-sharpei01
    monrun2: True
    monrun:
        load_average_relative:
            warn: 2
            crit: 4
        nginx_404:
            warn: 30000
            crit: 50000
        unispace:
            warn: 80
            crit: 90
            repack: 95
        sharpei:
            groups:
                - db_13a18a2d_981e_4c68_9927_3735f2eb84ea
                - db_43e9f9c8_cb2a_4491_ab83_ec6fc5639049
                - db_4e352527_2517_44d9_bb1e_5d310ee2e86c
                - db_55793098_692c_40b6_bd0b_0c28b7bbdc90
                - db_9226f3d1_29e7_441f_b58d_9e42b585dc85
                - db_96e38458_e2c5_4b53_a3ec_d39bb26722f6
                - db_c01c3063_8a90_4636_8cae_eb0e06b1c76c
                - db_d95ed886_5a3a_4e9f_ae79_e6002177aba4
                - db_5f249a80_25f5_48a7_92c3_a6ba3c0b84f0
                - db_mdbo56iaamqov23j5ktq
                - db_mdbre9dafdii1hofjgsr
                - db_mdbqqc3fkek0p5qedmdh
                - db_mdbdtge9nr5fcsuqkti8
                - db_mdbjbdmdj2opqnm9qe80
                - db_mdbvui26bht9hiu7r6u7
                - db_mdb1puok1gd8pg4rdr4o
                - db_mdbk7s3fv9r636cd7mbr
                - db_mdbd22lalpovndi7ndka
                - db_mdblfvks4tmero7rnmuq
                - db_mdb76eipcmp2uq8dni20
                - db_mdbe9618j01fp2o9o2i7
                - db_mdb7tjrif5tcjoi00f0r
                - db_mdbphpuho2v360j2bruf
                - db_mdboaaqbqcurcgmpg6fu
                - db_mdb57f180vupm0c7d9qs
                - db_mdbpj9m59fqq5nqqvr42
                - db_mdbf0olgfg9aspbbj0dh
                - db_mdbf4374fbb7eb1358rs
                - db_mdb7cvbvpenmbvt915hm
                - db_mdbi35lp70glc78nnn3v
                - db_mdba22grqt5p1g3f93a7
                - db_mdbk09krgi8gn0f430ml
                - db_mdb51450an4dsqklasjc
                - db_mdboat2eeucid77j3ree
                - db_mdb8rvsohppvgqgj7d79
                - db_mdb5k2js3f1lpl21gdh1
                - db_mdb6l8d7lh0tqnut7i0c
                - db_mdb2s97rlf951d4rkcu2
                - db_mdbrcc4g2boer1deo3d2
                - db_mdbd4hgfvma5qgmq9njh
                - db_mdbifrocn5ql60vb7ser
                - db_mdb5j60n2kb4nfgsvofb
                - db_mdbeh6np45v2s4dkmgmj
                - db_mdbbntjso8gl2ae64lft
                - db_mdbjbit55847begfcer4
                - db_mdbcdrr1ua67vqdp42aa
                - db_mdbvj98j0r9gkco3vcs4
                - db_mdb378e8cunq0p2sb0b9
                - db_mdb0k0aja7ca8dnmk8lq
                - db_mdbn7pjuecp8fagrgekp
                - db_mdbjht8dp60gjgksnpig
    l3host: True
    pg:
        version:
            major_num: 906
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    use_walg: True
    use_wale: False
    use_barman: False
    s3_bucket: 'disk-backup-pg'
    dbaas:
        cluster_id: ds-sharpei01
    s3:
        gpg_key_id: ds-sharpei01
    walg:
        backup_keep: 7
        delta_max_steps: 2
    ship_logs: True

gpg-yav-secrets: {{ salt.yav.get('sec-01d3nkx508345z2s3tz52cg2pd') | json }}

include:
    - envs.prod
    - disk_pgsync_conf
    - disk_logrotate_conf
    - private.pg.users.prod.common
    - private.pg.users.prod.disk_sharpei_datasync
    - private.pg.tls.prod
    - private.selfdns.realm-disk
    - private.pg.barman.pg2barman.prod.keys
    - private.s3.prod.disk_s3backup
    - private.abyssync.prod.disk
    - private.push-client.prod.disk
