mine_functions:
    grains.item:
        - id
        - role
        - ya
        - pg
        - virtual

data:
    pg:
        version:
            major_num: 1000
    condgroup: disk_sharpei_datasync_qa
    runlist:
        - components.postgres
        - components.pg-dbs.sharddb
        - components.sharpei
        - components.monrun2.disk
    sharpei:
        flavor: datasync
        zk_hosts: zk-pgsync01e.disk.yandex.net:2181,zk-pgsync01f.disk.yandex.net:2181,zk-pgsync01h.disk.yandex.net:2181,zk-pgsync01v.disk.yandex.net:2181
    pgsync:
        zk_lockpath_prefix: /pgsync/ds-sharpei-qa01
    yasmagent:
        sysconfig_pkg: sharpei
    dbname: sharddb
    separate_array_for_xlogs: False
    config:
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
        shared_buffers: 128MB
        archive_mode: 'on'
        log_min_duration_statement: 1s
        pool_mode: transaction
        wal_log_hints: 'on'
        max_prepared_transactions: 1000
        log_rotate_by_size: True
        archive_timeout: 60
    sysctl:
        vm.nr_hugepages: 0
    monrun2: True
    monrun:
        load_average_relative:
            warn: 2
            crit: 4
        nginx_499:
            warn: 3000
            crit: 6000
        sharpei:
            groups:
                - db_mdbjv7aa9pamo7mrjspl
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    use_walg: True
    use_wale: False
    use_barman: False
    s3_bucket: 'disk-backup-pg'
    walg:
        backup_keep: 7
        delta_max_steps: 2
    ship_logs: True

gpg-yav-secrets: {{ salt.yav.get('sec-01d5xty6b2e1zhph9pd1eesebj') | json }}

include:
    - disk_pgsync_conf
    - envs.qa
    - private.pg.users.qa.common
    - private.pg.users.prod.sharpei
    - private.pg.tls.prod
    - private.abyssync.prod.disk
    - private.s3.prod.disk_s3backup
    - private.push-client.prod.disk
