mine_functions:
    grains.item:
        - id
        - role
        - ya
        - pg
        - virtual

{% set shard = salt['grains.get']('id').split('.')[0][-3:-1] %}
{% if shard == '02' %}
{%     set pg_master = salt['grains.get']('id').replace(shard, '01') %}
pg-master: {{ pg_master }}
{% elif shard not in ['01', '02'] %}
{%     set pg_master = salt['grains.get']('id').replace(shard, '02') %}
pg-master: {{ pg_master }}
{% endif %}

data:
    condgroup: disk_sharpei_mpfs
    runlist:
        - components.postgres
        - components.pg-dbs.sharddb
        - components.sharpei
        - components.monrun2.disk
        - components.push-client
{% if salt['grains.get']('virtual', 'lxc') == 'physical' %}
        - components.hw-watcher
        - components.yandex-lazy-trim
{% endif %}
    sharpei:
        cascade: True
        flavor: disk
        zk_hosts: zk-pgsync01e.disk.yandex.net:2181,zk-pgsync01f.disk.yandex.net:2181,zk-pgsync01h.disk.yandex.net:2181,zk-pgsync01v.disk.yandex.net:2181
        nginx:
            tskv_format: ydisk-nginx-access-log-sharpei-mpfs
    yasmagent:
        prj_split_by_shard: False
        sysconfig_pkg: sharpei
        instances:
            - mailpostgresql
            - mailsharpei
    dbname: sharddb
    separate_array_for_xlogs: False
    monrun2: True
    config:
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
        log_min_duration_statement: 100ms
        pool_mode: transaction
        wal_log_hints: 'on'
        auto_kill_timeout: 2 hours
        max_prepared_transactions: 1000
        max_replication_slots: 20
        max_wal_senders: 20
        log_rotate_by_size: True
        archive_timeout: 60
    pgsync:
{% if shard != '01' %}
        replication_source: {{ pg_master }}
{% endif %}
        zk_lockpath_prefix: /pgsync/mpfs-sharpei01
    monrun:
        load_average_relative:
            warn: 2
            crit: 4
        nginx_404:
            warn: 150000
            crit: 200000
        nginx_499:
            warn: 1000
            crit: 3000
        unispace:
            warn: 80
            crit: 90
            repack: 95
        sharpei:
            groups:
                - disk_mpfs_db
                - disk_common_db
                - db_mdbdafl4k9smvb1v7287
                - db_mdbhficvb99u10is8qg0
                - db_mdbf02odfcmhe2tnnjag
                - db_mdbuu0l29bpk88n9km85
        free_space_trend:
            skip_root: True
    l3host: True
    network_autoconf: True
    pg:
        version:
            major_num: 906
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    use_walg: True
    use_wale: False
    use_barman: False
    s3_bucket: 'disk-backup-pg'
    dbaas:
        cluster_id: mpfs-sharpei01
    s3:
        gpg_key_id: mpfs-sharpei01
    walg:
        backup_keep: 14
        delta_max_steps: 2
    ship_logs: True
    lazy-trim:
        cron_time: '30 */4 * * *'
        mountpoint: '/'

gpg-yav-secrets: {{ salt.yav.get('sec-01d3r1wnmtrqss8nh790gjabwc') | json }}

include:
    - envs.prod
    - disk_pgsync_conf
    - disk_logrotate_conf
    - private.pg.users.prod.common
    - private.pg.users.prod.disk_sharpei_mpfs
    - private.pg.tls.prod
    - private.selfdns.realm-disk
    - private.abyssync.prod.disk
    - private.pg.barman.pg2barman.prod.keys
    - private.s3.prod.disk_s3backup
    - private.push-client.prod.disk
