mine_functions:
    grains.item:
        - id
        - role
        - ya
        - pg
        - virtual

data:
    condgroup: disk_sharpei_smc
    runlist:
        - components.postgres
        - components.pg-dbs.sharddb
        - components.sharpei
        - components.monrun2.disk
        - components.push-client
    sharpei:
        flavor: disk
        zk_hosts: zk-pgsync01e.disk.yandex.net:2181,zk-pgsync01f.disk.yandex.net:2181,zk-pgsync01h.disk.yandex.net:2181,zk-pgsync01v.disk.yandex.net:2181
        nginx:
            tskv_format: ydisk-nginx-access-log-sharpei-smc
    yasmagent:
        prj_split_by_shard: False
        sysconfig_pkg: sharpei
        instances:
            - mailpostgresql
            - mailsharpei
    dbname: sharddb
    separate_array_for_xlogs: False
    monrun2: True
    config:
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
        log_min_duration_statement: 100ms
        pool_mode: transaction
        wal_log_hints: 'on'
        auto_kill_timeout: 2 hours
        max_prepared_transactions: 1000
        log_rotate_by_size: True
        archive_timeout: 60
    pgsync:
        zk_lockpath_prefix: /pgsync/smc-sharpei01
    monrun:
        load_average_relative:
            warn: 2
            crit: 4
        nginx_404:
            warn: 100000
            crit: 1000000
        unispace:
            warn: 80
            crit: 90
            repack: 95
        sharpei:
            groups:
                - disk_smcdb
    l3host: True
    network_autoconf: True
    pg:
        version:
            major_num: 906
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    use_walg: True
    use_wale: False
    use_barman: False
    s3_bucket: 'disk-backup-pg'
    dbaas:
        cluster_id: smc-sharpei01
    s3:
        gpg_key_id: smc-sharpei01
    walg:
        backup_keep: 7
        delta_max_steps: 2
    ship_logs: True

gpg-yav-secrets: {{ salt.yav.get('sec-01d3p5d070k0dps73rhe4n9jx2') | json }}

include:
    - envs.prod
    - disk_pgsync_conf
    - disk_logrotate_conf
    - private.pg.users.prod.common
    - private.pg.users.prod.disk_sharpei_smc
    - private.pg.tls.prod
    - private.selfdns.realm-disk
    - private.abyssync.prod.disk
    - private.pg.barman.pg2barman.prod.keys
    - private.s3.prod.disk_s3backup
    - private.push-client.prod.disk
