mine_functions:
    grains.item:
        - id
        - role
        - ya
        - pg
        - virtual

data:
    condgroup: disk_smcdb
    runlist:
        - components.postgres
        - components.pg-dbs.smartcachedb
        - components.monrun2.disk
        - components.hw-watcher
    dbname: smartcachedb
    config:
        shared_preload_libraries: pg_stat_statements,pg_stat_kcache,repl_mon
        effective_cache_size: 100GB
        lock_timeout: 2s
        wal_log_hints: 'on'
        wal_keep_segments: 512
        checkpoint_segments: 600
        autovacuum_vacuum_scale_factor: 0.001
        autovacuum_analyze_scale_factor: 0.01
        autovacuum_vacuum_cost_limit: 3000
        autovacuum_vacuum_cost_delay: 5
        work_mem: 64MB
        pool_mode: transaction
        server_reset_query: 'DISCARD ALL'
        server_reset_query_always: 1
        log_keep_days: 7
        log_rotate_by_size: True
        log_min_duration_statement: 1s
        idle_in_transaction_session_timeout: 10800000
        max_wal_size: 64GB
    pgbouncer:
        count: 16
        internal_count: 4
        log_connections: 0
        log_disconnections: 0
    sysctl:
        vm.swappiness: 0
        vm.nr_hugepages: 2500
    add_to_sharpei: True
    sharpei_condgroup: disk_sharpei_smc
    sharpei_balancer: smc-sharpei.disk.yandex.net
    monrun:
        pg_log_errors:
            warn: '10\ 30000'
            crit: '10000\ 60000'
        unispace:
            warn: 80
            crit: 90
            repack: 95
    monrun2: True
    l3host: True
    network_autoconf: True
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    backup:
        archive:
            bwlimit: 20000
    yasmagent:
        prj_split_by_shard: False
    s3_bucket: 'disk-backup-pg'
    use_wale: False
    walg:
        backup_keep: 21
        delta_max_steps: 6
        compression_method: brotli
    ship_logs: True
    use_walg: True
    use_barman: False
    auto_resetup: True
    index_repack:
        bytes_min: 500000000
        perc_min: 25

include:
    - disk_smcdb.{{ salt['grains.get']('id').split('.')[0][:-1] }}
    - disk_pgsync_conf
    - disk_logrotate_conf
    - index_repack
    - envs.prod
    - private.pg.users.prod.common
    - private.pg.users.prod.smartcache
    - private.pg.users.prod.disk_sharpei_smc
    - private.pg.tls.prod
    - private.pg.barman.pg2barman.prod.keys
    - private.selfdns.realm-disk
    - private.s3.prod.disk_s3backup
    - private.abyssync.prod.disk
    - private.push-client.prod.disk
