{% set shard = salt['grains.get']('id').split('.')[0][-2:][:-1] %}

include:
    - envs.prod
    - private.mongodb.prod.docdb
{% if 'disk.yandex.net' in salt['grains.get']('id') %}
    - private.selfdns.realm-disk
{% else %}
    - private.selfdns.realm-mail
{% endif %}

data:
    l3host: True
    runlist:
        - components.graphite.docdb
        - components.monrun2.mongodb
        - components.monrun2.disk
        - components.mongodb30.auth
        - components.mongodb-dbs.docdb
    monrun:
        lag:
            warn: 3700
            crit: 4000
        unispace:
            crit: 95
            warn: 90
    monrun2: True
    mongodb_version: 3.2.20
    mongodb:
        use_ssl: False
common:
    condgroup: mail_docdb-hidden
