include:
    - envs.prod
    - private.mongodb.prod.docdb

{% if 'disk.yandex.net' in salt['grains.get']('id') %}
    - private.selfdns.realm-disk
{% else %}
    - private.selfdns.realm-mail
{% endif %}

{% set shard = salt['grains.get']('id').split('.')[0][-2:][:-1] %}
data:
    l3host: True
    runlist:
        - components.graphite.docdb
        - components.monrun2.mongodb
        - components.monrun2.disk
        - components.mongodb30.auth
        - components.mongodb-dbs.docdb
        - components.mongodb-dbs.docdb.mongos
        - components.mongodb-dbs.docdb.configsrv
        - components.hw-watcher
        - components.mongodb-mms-automation-agent
        - components.mongodb-mms-monitoring-agent
    monrun:
        unispace:
            crit: 95
            warn: 90
    monrun2: True
    mongodb_version: 3.2.20
    hw_watcher:
        mail: disk-admin@yandex-team.ru
        reaction:
          - mail
        initiator: disk-admin
    mongodb:
        use_ssl: False

common:
    condgroup: mail_docdb
