#!/usr/bin/env python
# encoding: utf-8

import argparse
import string
from random import sample, choice
import os
import sys

chars = string.letters + string.digits

parser = argparse.ArgumentParser()

parser.add_argument('login',
                    type=str,
                    nargs=1,
                    help='Login for new user')

parser.add_argument('--password_length',
                    type=int,
                    default=25)

parser.add_argument('--port',
                    type=int,
                    default=6432,
                    help='Port for pgpass generation')

parser.add_argument('--db',
                    type=str,
                    help='Database for connect')

parser.add_argument('--superuser',
                    action="store_true",
                    help='Make user superuser (like postgres)')

parser.add_argument('--replication',
                    action="store_true",
                    help='Allow replication (like repl)')

parser.add_argument('--no_create',
                    action="store_true",
                    help='Do not create user on cluster')

parser.add_argument('--no_bouncer',
                    action="store_true",
                    help='Do not allow user in pgbouncer')

parser.add_argument('--conn_limit',
                    type=int,
                    default=25,
                    help='Limit connections for user (-1 for no limit)')

args = parser.parse_args()

db = args.login[0] + 'db'

if args.db is not None:
    db = args.db

files = []

for d in os.listdir('.'):
    if os.path.isdir(d):
        if os.path.exists(os.path.join(d, args.login[0] + '.sls')):
            print 'User already exists in env %s' % d
            sys.exit(1)
        else:
            files.append(os.path.join(d, args.login[0] + '.sls'))

for p in files:
    result = '''data:
    config:
        pgusers:
            %s:
                password: %s
                allow_port: '%d'
                allow_db: %s
                superuser: %s
                replication: %s
                create: %s
                bouncer: %s
                conn_limit: %d
                connect_dbs:
                    - '%s'
''' % (args.login[0],
       ''.join(choice(chars) for _ in range(args.password_length)),
       args.port,
       db,
       str(args.superuser),
       str(args.replication),
       str(not args.no_create),
       str(not args.no_bouncer),
       args.conn_limit,
       db)

    with open(p, 'w') as f:
        f.write(result)
