#!/usr/bin/env python

import json
import os
import re

def pg():
    data = {'pgbouncer_dbs': {}}
    try:
        import psycopg2
        user = 'monitor'
        password = ''

        with open(os.path.expanduser("~/.pgpass")) as pgpass:
            for line in pgpass:
                tokens = line.rstrip().split(':')
                if tokens[3] == user:
                    password = tokens[4]
                    break

        conn = psycopg2.connect("host=localhost port=5432 dbname=postgres " +
                                "user=%s password=%s " % (user, password) +
                                "connect_timeout=1")
        cur = conn.cursor()

        cur.execute("SELECT datname FROM pg_database WHERE " +
                    "datistemplate = false AND datname != 'postgres'" +
                    "ORDER BY datname")
        databases = [x[0] for x in cur.fetchall()]

        cur.close()
        conn.close()

        for dbname in databases:
            try:
                conn = psycopg2.connect("host=localhost port=5432 dbname=%s "
                                        "user=%s password=%s "
                                        "connect_timeout=1" % (dbname, user,
                                                               password))
                cur = conn.cursor()

                cur.execute("SELECT 1 FROM pg_tables "
                            "WHERE schemaname = 'plproxy' "
                            "AND tablename = 'connections'")
                if cur.rowcount == 0:
                    continue

                cur.execute("SELECT conn_string FROM plproxy.connections")
                for i in cur.fetchall():
                    conn_string = i[0]
                    if 'host=localhost' not in conn_string or \
                            'port=7432' not in conn_string:
                        continue

                    db = [i.replace('dbname=', '') for i in \
                          conn_string.split() if i.startswith('dbname=')][0]
                    if re.match('[a-z0-9.-]+__[0-9]+__[a-zA-Z0-9_-]+', db):
                        host, port, name = db.split('__')
                        data['pgbouncer_dbs'][db] = \
                            'host=%s port=%s dbname=%s' % (host, port, name)

                cur.close()
                conn.close()
            except Exception:
                continue

        with open('/tmp/.grains_pgproxy.cache', 'w') as cache:
            cache.write(json.dumps(data))

    except Exception:
        if os.path.exists('/tmp/.grains_pgproxy.cache'):
            with open('/tmp/.grains_pgproxy.cache', 'r') as cache:
                data = json.loads(cache.read())

    return { 'pgproxy': data }


if __name__ == '__main__':
    from pprint import pprint
    pprint(pg())
