# -*- coding: utf-8 -*-
"""
DBaaS module for salt
"""

from __future__ import absolute_import, print_function, unicode_literals

import logging

from salt.ext import six

LOG = logging.getLogger(__name__)


def __virtual__():
    """
    We always return True here (we are always available)
    """
    return True


def feature_flag(flag_name):
    """
    Check if feature flag is enabled
    """
    LOG.info('Checking if %s is enabled', flag_name)
    flags = __salt__['pillar.get']('feature_flags', {})
    LOG.debug('Enabled flags: %s', ','.join(sorted(flags)))
    ret = flag_name in flags
    LOG.debug('%s is %s', flag_name, 'enabled' if ret else 'disabled')
    return ret
