/etc/yandex/abyssync.yaml:
  file.managed:
    - source: salt://{{ slspath }}/conf/abyssync.yaml
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - template: jinja

/usr/bin/maintenance:
  file.managed:
    - source: salt://{{ slspath }}/scripts/maintenance
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
    - template: jinja

/usr/bin/postgres-step-down:
  file.managed:
    - source: salt://{{ slspath }}/scripts/postgres-step-down
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
    - template: jinja

abyssync-pkg:
  pkg.installed:
    - name: abyssync
    - version: 0.2-7587412

abyssync:
  service:
    - running
    - enable: True
    - require:
      - pkg: abyssync
    - watch:
        - file: /etc/yandex/abyssync.yaml
        - pkg: abyssync-pkg
