pin-atop-from-mirror:
  file.absent:
    - name: /etc/apt/preferences.d/41pin-atop

atop-package:
  pkg.installed:
    - name: atop
    - version: 2.3.0-yandex7

/etc/default/atop:
  file.managed:
    - source: salt://components/atop/conf/atop-default
    - user: root
    - group: root
    - permissions: 644
    - template: jinja

/etc/init/atop.conf:
  file.absent

/etc/init.d/atop:
  file.managed:
    - source: salt://components/atop/conf/atop-init.d
    - mode: 755 
    - user: root
    - group: root
    - makedirs: True
    - follow_symlinks: False

atop-service:
  service.running:
    - enable: True
    - name: atop
    - watch:
      - file: /etc/default/atop
      - pkg: atop-package

/etc/cron.d/wd-atop:
  file.managed:
    - source: salt://components/atop/conf/atop-watchdog
    - user: root
    - group: root
    - permissions: 644
