{% if not salt['pillar.get']('data:lxc_used', False) and salt['grains.get']('virtual_subtype', None) != 'Docker' %}
{% import_yaml slspath + "/defaults.yaml" as defaults %}
{% set cgroup = salt['pillar.get']('data:cgroup', defaults, merge=True) %}

libcgroup-pkg:
    pkg.installed:
        - pkgs:
{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
            - libcgroup1: 0.41-8yandex7
            - cgroup-tools: 0.41-8yandex7
{% else %}
            - libcgroup: 0.40.rc1-16.el6
{% endif %}

/etc/cgconfig.conf:
    file.managed:
        - template: jinja
{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
        - source: salt://components/cgroup/conf/ubuntu-cgconfig.conf
{% else %}
        - source: salt://components/cgroup/conf/cgconfig.conf
        - mode: 755
        - user: root
        - group: root
{% endif %}

{% if salt['grains.get']('virtual', 'physical') != 'lxc' %}
{% for g in cgroup.get('groups', {}).keys() %}
{{ g }}-cgconfig.d:
    file.managed:
        - template: jinja
        - name: /etc/cgconfig.d/{{ g }}.conf
        - source: salt://components/cgroup/conf/cgroup-cgconfig.conf
        - makedirs: True
        - defaults:
            group: {{ cgroup['groups'].get(g, {}) }}
            group_name: {{ g }}
        - require:
            - pkg: libcgroup-pkg
        - watch_in:
{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
            - service: cgroup-create-service
{% else %}
            - cmd: cgroup-create-service
{% endif %}
            - service: cgroup-rules-service
        - require_in:
            - service: cgroup-create-service
            - service: cgroup-rules-service
{% endfor %}

/etc/cgrules.conf:
    file.managed:
        - source: salt://components/cgroup/conf/cgrules.conf
        - template: jinja
        - defaults:
            rules: {{ cgroup['rules'] }}
        - require:
            - pkg: libcgroup-pkg
{% endif %}

cgroup-create-service:
{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
    file.managed:
        - name: /etc/init/cgroup-lite.conf
        - source: salt://components/cgroup/conf/ubuntu-cgroup-lite.init
        - require:
            - pkg: libcgroup-pkg
    service.running:
        - name: cgroup-lite
        - enable: True
        - require:
            - file: cgroup-create-service
        - watch:
            - file: cgroup-create-service
{% else %}
    cmd.wait:
        - name: 'service cgred stop; service cgconfig stop; for i in /cgroup/*; do umount $i || true; done'
        - watch_in:
            - service: cgroup-create-service
        - require_in:
            - service: cgroup-create-service
    service.running:
        - name: cgconfig
        - enable: True
        - require:
            - file: /etc/cgconfig.conf
            - pkg: libcgroup-pkg
{% endif %}

{% if salt['grains.get']('virtual', 'physical') != 'lxc' %}
cgroup-rules-service:
{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
    file.managed:
        - name: /etc/init/cgred.conf
        - source: salt://components/cgroup/conf/ubuntu-cgred.init
        - require_in:
            - service: cgroup-rules-service
{% endif %}
    service.running:
        - name: cgred
        - enable: True
        - require:
            - service: cgroup-create-service
            - file: /etc/cgrules.conf
        - watch:
            - file: /etc/cgrules.conf
{% endif %}
{% endif %}
