{% from "components/clickhouse/map.jinja" import ch, ch_backup, template with context %}

ch-backup-packages:
    pkg.installed:
        - pkgs:
            - ch-backup: {{ ch_backup.version }}
            - python3.5: 3.5.2-3yandex2
            - zk-flock
            - python-kazoo: 2.2.1-yandex1
            - s3cmd

/etc/yandex/ch-backup/ch-backup.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/ch-backup.conf
        - mode: 644
        - makedirs: True
        - require:
            - pkg: ch-backup-packages

/etc/yandex/ch-backup/s3cmd.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/s3cmd.conf
        - template: jinja
        - user: root
        - mode: 640
        - require:
            - pkg: ch-backup-packages

{% if ch.zk_hosts %}
/etc/yandex/ch-backup/zk-flock.json:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/zk-flock.json
        - mode: 644
        - makedirs: True
        - require:
            - pkg: ch-backup-packages
{% endif %}

/etc/logrotate.d/ch-backup:
    file.managed:
        - source: salt://{{ slspath }}/conf/logrotate.conf
        - mode: 644
        - require:
            - pkg: ch-backup-packages

/var/log/ch-backup:
    file.directory:
        - dir_mode: 775
        - makedirs: True
        - require:
            - pkg: ch-backup-packages

{% if not template %}
{%     if ch.zk_hosts %}
ch-backup-zk-root:
    zookeeper.present:
        - name: {{ ch_backup.zk_path }}
        - value: ''
        - makepath: True
        - hosts: {{ ch.zk_hosts }}
        - require:
            - pkg: ch-backup-packages
        - require_in:
            - file: /etc/cron.d/ch-backup
{%     endif %}

/etc/cron.d/ch-backup:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/ch-backup.cron
        - mode: 644
        - require:
            - pkg: ch-backup-packages
{% endif %}

{% if salt['pillar.get']('restore-from:cid') %}
restore-from-pillar-data-exists:
    test.check_pillar:
        - dictionary: data:restore-from-pillar-data

/etc/yandex/ch-backup/ch-backup-restore.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/ch-backup-restore.conf
        - mode: 644
        - makedirs: True
        - require:
            - pkg: ch-backup-packages
            - test: restore-from-pillar-data-exists

restore-ch-from-backup:
    cmd.run:
        - name: >
            ch-backup -c /etc/yandex/ch-backup/ch-backup-restore.conf
            restore
{%     if salt['pillar.get']('restore-from:schema-only') %}
            --schema-only
{%     endif %}
            {{ salt['pillar.get']('restore-from:backup-id') }} &&
            touch /tmp/restore-ch-from-backup-success
        - env:
            - LC_ALL: C.UTF-8
            - LANG: C.UTF-8
        - require:
            - pkg: ch-backup-packages
            - file: /etc/yandex/ch-backup/ch-backup-restore.conf
            - file: /var/log/ch-backup
            - file: /etc/yandex/ch-backup/zk-flock.json
{%     if ch.zk_hosts %}
            - zookeeper: ch-backup-zk-root
{%     endif %}
        - require_in:
{%     for database in ch.databases %}
            - cmd: create_database_{{ database }}
{%     endfor %}
{%     for database in ch.schemas %}
            - cmd: apply_{{ database }}
{%     endfor %}
        - unless:
            - ls /tmp/restore-ch-from-backup-success

remove-ch-backup-restore-conf:
    cmd.run:
        - name: rm -f /etc/yandex/ch-backup/ch-backup-restore.conf
        - require:
            - cmd: restore-ch-from-backup

{% endif %}{# restore-from #}

{% if salt['pillar.get']('do-backup') %}
do-ch-backup:
    cmd.run:
        - name: >
            zk-flock -c /etc/yandex/ch-backup/zk-flock.json lock
            "timeout 610m ch-backup backup --force"
        - env:
            - LC_ALL: C.UTF-8
            - LANG: C.UTF-8
        - require:
            - pkg: ch-backup-packages
            - file: /etc/yandex/ch-backup/ch-backup.conf
            - file: /var/log/ch-backup
            - file: /etc/yandex/ch-backup/zk-flock.json
{%     if ch.zk_hosts %}
            - zookeeper: ch-backup-zk-root
{%     endif %}
{%     for database in ch.databases %}
            - cmd: create_database_{{ database }}
{%     endfor %}
{% endif %}{# do-backup #}
