#!/usr/bin/env python

import re
import sys
import json
import socket
import os
import argparse
{% set dbaas = salt['pillar.get']('data:dbaas') %}

def gen_getter(itype, ctype, tier):
    with open('/tmp/.grains_conductor.cache') as f:
        grains = json.loads(''.join(f.readlines()))

{% if dbaas %}
    prj = {{ dbaas.get('shard_id') or 'none' | python }}
{% else %}
    prj = socket.gethostname().split('.')[0][:-1]
{% endif %}
    datacenter = grains.get('short_dc', 'nodc')
    if not datacenter:
        datacenter = grains.get('switch')[:3]
    res = socket.getfqdn() + ':11003@' + itype + \
        ' a_itype_' + itype + \
        ' a_prj_' + prj + \
        ' a_ctype_' + ctype + ' a_geo_' + datacenter + \
        ' a_tier_' + tier
    return res

def main():
    itypes = "{{ itypes }}".split(',')
{% if dbaas %}
    ctype = {{ dbaas['cluster_id'] | python }}
{% else %}
    ctype = "{{ ctype }}".replace('_', '-')
{% endif %}
    tier = 'replica'
    
    reports = [gen_getter(itype, ctype, tier)  for itype in itypes]
    print('\n'.join(reports))

if __name__ == '__main__':
    main()

