CREATE DATABASE IF NOT EXISTS dbaas;

CREATE TABLE IF NOT EXISTS dbaas.postgres_part
(
    log_date Date,
    log_time DateTime,
    user_name String,
    database_name String,
    process_id UInt32,
    connection_from String,
    session_id String,
    session_line_num UInt32,
    command_tag String,
    session_start_time DateTime,
    virtual_transaction_id String,
    transaction_id Int64,
    error_severity String,
    sql_state_code String,
    message String,
    detail String,
    hint String,
    internal_query String,
    internal_query_pos UInt32,
    context String,
    query String,
    query_pos UInt32,
    location String,
    application_name String,
    ms UInt16,
    cluster String,
    hostname String,
    timestamp UInt32
)
ENGINE = ReplicatedMergeTree('/clickhouse/{cluster}/tables/{shard}/dbaas_postgres_part', '{replica}',  log_date, (log_date, cluster), 8192);


CREATE TABLE IF NOT EXISTS dbaas.postgres AS dbaas.postgres_part ENGINE = Distributed(logsdb, dbaas, postgres_part, sipHash64(cluster));

CREATE TABLE IF NOT EXISTS dbaas.pgbouncer_part
(
    session_id String,
    db String,
    user String,
    source String,
    text String,
    pid UInt32,
    level String,
    ms UInt16,
    log_time DateTime,
    log_date Date,
    cluster String,
    hostname String,
    timestamp UInt32
)
ENGINE = ReplicatedMergeTree('/clickhouse/{cluster}/tables/{shard}/dbaas_pgbouncer_part', '{replica}',  log_date, (log_date, cluster), 8192);

CREATE TABLE IF NOT EXISTS dbaas.pgbouncer AS dbaas.pgbouncer_part ENGINE = Distributed(logsdb, dbaas, pgbouncer_part, sipHash64(cluster));


CREATE TABLE IF NOT EXISTS dbaas.odyssey_part
(
    client_id String,
    server_id String,
    context String,
    db String,
    user String,
    text String,
    pid UInt32,
    level String,
    log_time DateTime,
    log_date Date,
    ms UInt16,
    cluster String,
    hostname String,
    timestamp UInt32
)
ENGINE = ReplicatedMergeTree('/clickhouse/{cluster}/tables/{shard}/dbaas_odyssey_part', '{replica}',  log_date, (log_date, cluster), 8192);

CREATE TABLE IF NOT EXISTS dbaas.odyssey AS dbaas.odyssey_part ENGINE = Distributed(logsdb, dbaas, odyssey_part, sipHash64(cluster));


CREATE TABLE IF NOT EXISTS dbaas.mongod_part
(
    message String,
    context String,
    component String,
    severity String,
    ms UInt16,
    log_time DateTime,
    log_date Date,
    cluster String,
    hostname String,
    timestamp UInt32
)
ENGINE = ReplicatedMergeTree('/clickhouse/{cluster}/tables/{shard}/dbaas_mongod_part', '{replica}',  log_date, (log_date, cluster), 8192);

CREATE TABLE IF NOT EXISTS dbaas.mongod AS dbaas.mongod_part ENGINE = Distributed(logsdb, dbaas, mongod_part, sipHash64(cluster));


CREATE TABLE IF NOT EXISTS dbaas.mongos_part
(
    message String,
    context String,
    component String,
    severity String,
    ms UInt16,
    log_time DateTime,
    log_date Date,
    cluster String,
    hostname String,
    timestamp UInt32
)
ENGINE = ReplicatedMergeTree('/clickhouse/{cluster}/tables/{shard}/dbaas_mongos_part', '{replica}',  log_date, (log_date, cluster), 8192);

CREATE TABLE IF NOT EXISTS dbaas.mongos AS dbaas.mongos_part ENGINE = Distributed(logsdb, dbaas, mongos_part, sipHash64(cluster));


CREATE TABLE IF NOT EXISTS dbaas.mongocfg_part
(
    message String,
    context String,
    component String,
    severity String,
    ms UInt16,
    log_time DateTime,
    log_date Date,
    cluster String,
    hostname String,
    timestamp UInt32
)
ENGINE = ReplicatedMergeTree('/clickhouse/{cluster}/tables/{shard}/dbaas_mongocfg_part', '{replica}',  log_date, (log_date, cluster), 8192);

CREATE TABLE IF NOT EXISTS dbaas.mongocfg AS dbaas.mongocfg_part ENGINE = Distributed(logsdb, dbaas, mongocfg_part, sipHash64(cluster));


CREATE TABLE IF NOT EXISTS dbaas.clickhouse_part
(
    message String,
    cluster String,
    hostname String,
    component String,
    thread UInt16,
    severity String,
    timestamp UInt32,
    ms UInt16,
    log_date Date,
    log_time DateTime
)
ENGINE = ReplicatedMergeTree('/clickhouse/{cluster}/tables/{shard}/dbaas_cluster_part', '{replica}',  log_date, (log_date, cluster), 8192);

CREATE TABLE IF NOT EXISTS dbaas.clickhouse AS dbaas.clickhouse_part ENGINE = Distributed(logsdb, dbaas, clickhouse_part, sipHash64(cluster));
