CREATE DATABASE IF NOT EXISTS mail;

CREATE TABLE IF NOT EXISTS mail.user_journal_part
(
    uid UInt64,
    date Date,
    ts DateTime,
    module String,
    ip String,
    target String,
    operation String,
    state String,
    affected UInt32,
    hidden UInt8,
    region_id UInt32,
    suid UInt64,
    mdb String,
    connection_id String,
    device_type String,
    internet_provider String
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/user_journal_part', '{replica}',  date, (date, uid), 8192);

CREATE TABLE IF NOT EXISTS mail.user_journal AS mail.user_journal_part ENGINE = Distributed(olapdb, mail, user_journal_part, intHash64(uid));


CREATE MATERIALIZED VIEW IF NOT EXISTS mail.user_activity_part
ENGINE = ReplicatedAggregatingMergeTree('/clickhouse/tables/{shard}/user_activity_part', '{replica}', date, (uid, module), 8192)
AS SELECT
    date,
    uid,
    module,
    maxState(ts) AS last_ts
FROM mail.user_journal_part
GROUP BY date, uid, module;

CREATE TABLE IF NOT EXISTS mail.user_activity AS mail.user_activity_part ENGINE = Distributed(olapdb, mail, user_activity_part, intHash64(uid));


CREATE MATERIALIZED VIEW IF NOT EXISTS mail.mdb_info_part
ENGINE = ReplicatedAggregatingMergeTree('/clickhouse/tables/{shard}/mdb_info_part', '{replica}', date, uid, 8192)
AS SELECT
    date,
    uid,
    anyLastIfState(mdb, mdb LIKE 'xdb%') AS mdb
FROM mail.user_journal_part
GROUP BY date, uid;

CREATE TABLE IF NOT EXISTS mail.mdb_info AS mail.mdb_info_part ENGINE = Distributed(olapdb, mail, mdb_info_part, intHash64(uid));


CREATE MATERIALIZED VIEW IF NOT EXISTS mail.user_first_login_part
ENGINE = ReplicatedAggregatingMergeTree('/clickhouse/tables/{shard}/user_first_login_part', '{replica}', date, uid, 8192)
AS SELECT
    date,
    uid,
    minState(ts) AS first_login
FROM mail.user_journal_part
WHERE operation = 'reset_fresh'
GROUP BY date, uid;

CREATE TABLE IF NOT EXISTS mail.user_first_login AS mail.user_first_login_part ENGINE = Distributed(olapdb, mail, user_first_login_part, intHash64(uid));

CREATE MATERIALIZED VIEW IF NOT EXISTS mail.user_daily_activity_part
(
    date Date,
    uid UInt64,
    web_cnt AggregateFunction(countIf, UInt8),
    mobile_cnt AggregateFunction(countIf, UInt8),
    fastsrv_cnt AggregateFunction(countIf, UInt8),
    imap_cnt AggregateFunction(countIf, UInt8),
    pop3_cnt AggregateFunction(countIf, UInt8),
    mailbox_oper_cnt AggregateFunction(countIf, UInt8)
) ENGINE = ReplicatedAggregatingMergeTree('/clickhouse/tables/{shard}/user_daily_activity_part', '{replica}', date, (uid, date), 8192) AS
SELECT
    date,
    uid,
    countIfState(module = 'wmi') AS web_cnt,
    countIfState(module = 'mobile') AS mobile_cnt,
    countIfState(module = 'fastsrv') AS fastsrv_cnt,
    countIfState(module = 'yserver_imap') AS imap_cnt,
    countIfState(module = 'yserver_pop') AS pop3_cnt,
    countIfState(module = 'mailbox_oper') AS mailbox_oper_cnt
FROM mail.user_journal_part
WHERE module IN ('wmi', 'mobile', 'fastsrv', 'yserver_imap', 'yserver_pop', 'mailbox_oper')
GROUP BY uid, date;

CREATE TABLE IF NOT EXISTS mail.user_daily_activity AS mail.user_daily_activity_part ENGINE = Distributed(olapdb, mail, user_daily_activity_part, intHash64(uid));
