CREATE DATABASE IF NOT EXISTS mailstatsdb;

CREATE TABLE IF NOT EXISTS mailstatsdb.mail_events_part (
    date Date,
    event_date DateTime DEFAULT now(),
    operation String,
    source Enum8('userjournal'=1),
    origin Enum8('web'=1, 'mobile'=2, 'imap'=3) DEFAULT 1,
    own_mail UInt8,
    uid UInt64,
    mid UInt64,
    action_date DateTime,
    tid UInt64,
    email_from String,
    local_from String,
    domain_from String,
    fid UInt64,
    readed_percent UInt8,
    widget String,
    list_id String,
    message_id String,
    x_mailer String,
    x_mailru_msgtype String,
    subject String,
    subject_hash String
) Engine = ReplicatedMergeTree('/clickhouse/tables/{shard}/mail_events_part', '{replica}', date, (uid, mid, date, operation, action_date, own_mail), 8192);

CREATE TABLE IF NOT EXISTS mailstatsdb.mail_events AS mailstatsdb.mail_events_part ENGINE = Distributed(olapdb, mailstatsdb, mail_events_part, intHash64(uid));

CREATE MATERIALIZED VIEW IF NOT EXISTS mailstatsdb.mails_part
Engine = ReplicatedMergeTree('/clickhouse/tables/{shard}/mails_part', '{replica}', date, (uid, mid, date, action_date, own_mail), 8192)
AS SELECT
    date,
    uid,
    mid,
    action_date,
    own_mail,
    source,
    email_from,
    local_from,
    domain_from,
    list_id,
    message_id,
    x_mailer,
    x_mailru_msgtype,
    subject,
    subject_hash
FROM mailstatsdb.mail_events_part
WHERE operation = 'receive';

CREATE TABLE IF NOT EXISTS mailstatsdb.mails AS mailstatsdb.mails_part ENGINE = Distributed(olapdb, mailstatsdb, mails_part, intHash64(uid));

CREATE TABLE IF NOT EXISTS mailstatsdb.pm_events_part (
    domain_hash UInt64,
    domain_from String,
    email_from String,
    received_date Date,
    list_id String,
    subject String,
    uid UInt64,
    mid UInt64,
    source Enum8('userjournal'=1),
    origin Enum8('web'=1, 'mobile'=2, 'imap'=3),
    operation String,
    action_date DateTime,
    fid UInt64,
    readed_percent UInt8,
    widget String,
    message_id String,
    x_mailer String,
    x_mailru_msgtype String,
    own_mail UInt8,
    local_from String,
    tid String
) Engine = ReplicatedMergeTree('/clickhouse/tables/{shard}/pm_events_part', '{replica}', received_date, (domain_from, email_from, received_date), 8192) ;

CREATE TABLE IF NOT EXISTS mailstatsdb.pm_events AS mailstatsdb.pm_events_part ENGINE = Distributed(olapdb, mailstatsdb, pm_events_part, intHash64(domain_hash));

