CREATE DATABASE IF NOT EXISTS ycloud_infra;

CREATE TABLE IF NOT EXISTS ycloud_infra.calculon_part
(
    Hostname String,
    HWID String,
    YCU String,
    VCPU_YCU String,
    rancid String DEFAULT '',
    Date Date,
    Time DateTime
)
ENGINE = ReplicatedMergeTree('/clickhouse/{cluster}/tables/{shard}/calculon_part', '{replica}', Date, (Time, Hostname), 8192);

CREATE TABLE IF NOT EXISTS ycloud_infra.calculon AS ycloud_infra.calculon_part ENGINE = Distributed(logsdb, ycloud_infra, calculon_part, sipHash64(Hostname));

CREATE TABLE IF NOT EXISTS ycloud_infra.disks_part
(
    Model String,
    Serial String,
    Rotational UInt8,
    HCTL String,
    SHED String,
    iopsRandRead UInt32,
    iopsRandWrite UInt32,
    iopsSeqRead UInt32,
    iopsSeqWrite UInt32,
    Hostname String,
    Rancid String DEFAULT '',
    Date Date,
    Time DateTime
)
ENGINE = ReplicatedMergeTree('/clickhouse/{cluster}/tables/{shard}/disks_part', '{replica}', Date, (Time, Hostname), 8192);

CREATE TABLE IF NOT EXISTS ycloud_infra.disks AS ycloud_infra.disks_part ENGINE = Distributed(logsdb, ycloud_infra, disks_part, sipHash64(Hostname));
