{% from "components/clickhouse/map.jinja" import ch, template, dbaas with context %}
{% set array_for_data = salt['pillar.get']('data:array_for_data', '/dev/md1') %}
{% set mountpoint_for_data = salt['pillar.get']('data:mountpoint_for_data', '/var/lib/clickhouse') %}

clickhouse-packages:
    pkg.installed:
        - pkgs:
            - clickhouse-client: {{ ch.ch_version }}
            - clickhouse-server-base: {{ ch.ch_version }}
            - clickhouse-server-common: {{ ch.ch_version }}
            - python-kazoo: 2.2.1-yandex1

yandex-graphite-checks-system:
    pkg.installed

{{ mountpoint_for_data }}:
    mount.mounted:
        - name: {{ mountpoint_for_data }}
        - device: {{ array_for_data }}
        - fstype: ext4
        - mkmnt: True
        - opts:
            - defaults
            - noatime
        - onlyif:
            - fgrep {{ array_for_data }} /etc/mdadm/mdadm.conf
        - require_in:
            - pkg: clickhouse-packages
    file.directory:
        - user: {{ ch.user }}
        - group: {{ ch.user }}
        - dir_mode: 775
        - require:
            - mount: {{ mountpoint_for_data }}

{{ mountpoint_for_data }}/lost+found:
    file.absent:
        - require:
            - mount: {{ mountpoint_for_data }}

{{ ch.config_prefix }}:
    file.directory:
        - user: {{ ch.user }}
        - group: {{ ch.user }}
        - makedirs: True
        - mode: 755
        - require:
            - pkg: clickhouse-packages

{% for config in ['config.xml', 'users.xml', 'cluster.xml'] %}
{{ ch.config_prefix }}/{{ config }}:
    file.managed:
        - template: jinja
        - source: salt://components/clickhouse/etc/clickhouse-server/{{ config }}
        - user: {{ ch.user }}
        - mode: 600
        - require:
            - pkg: clickhouse-packages
        - makedirs: True
        - require_in:
            - service: clickhouse-server
{% endfor %}

/etc/cron.d/clickhouse-server:
    file.managed:
        - source: salt://{{ slspath }}/conf/clickhouse-server.cron
        - mode: 644
        - require:
            - pkg: clickhouse-packages
        - require_in:
            - service: clickhouse-server

{% for config in ['config.xml'] %}
/etc/clickhouse-client/{{ config }}:
    file.managed:
        - template: jinja
        - source: salt://components/clickhouse/etc/clickhouse-client/{{ config }}
        - user: {{ ch.user }}
        - mode: 600
        - require:
            - pkg: clickhouse-packages
        - makedirs: True
{% endfor %}

{% for profile, settings in ch.profiles.items() %}
{{ ch.config_prefix }}/users.d/profile_{{ profile }}.xml:
    file.managed:
        - template: jinja
        - source: salt://components/clickhouse/etc/clickhouse-server/users.d/profile_template.xml
        - user: {{ ch.user }}
        - mode: 600
        - makedirs: True
        - defaults:
            profile: {{ profile }}
            settings: {{ settings }}
        - require:
            - pkg: clickhouse-packages
        - require_in:
            - service: clickhouse-server
{% endfor %}

{% for dictionary in ch.config.dictionaries %}
{{ ch.config_prefix }}/dictionaries.d/{{ dictionary.name }}.xml:
    file.managed:
        - template: jinja
        - source: salt://components/clickhouse/etc/clickhouse-server/dictionaries.d/template.xml
        - user: {{ ch.user }}
        - mode: 600
        - makedirs: True
        - defaults:
            dictionary: {{ dictionary }}
        - require:
            - pkg: clickhouse-packages
        - require_in:
            - service: clickhouse-server
{% endfor %}

{% if not template and ch.zk_path %}
clickhouse-zk-root:
    zookeeper.present:
        - name: {{ ch.zk_path }}
        - value: ''
        - makepath: True
        - hosts: {{ ch.zk_hosts }}
        - require:
            - pkg: clickhouse-packages
        - require_in:
            - service: clickhouse-server
{% endif %}

clickhouse-server:
    service.running:
        - enable: True
        - sig: clickhouse-server
    cmd.wait:
        - name: timeout 60 bash -c "while ! clickhouse-client -q 'select 1'; do sleep 1; done"
        - watch:
            - service: clickhouse-server

{% for database in ch.databases %}
create_database_{{ database }}:
    cmd.run:
        - name: 'clickhouse-client -q "CREATE DATABASE {{ database }}"'
        - unless: clickhouse-client -q "SELECT * FROM system.databases WHERE name = '{{ database }}'" | grep -q '{{ database }}'
        - require:
            - cmd: clickhouse-server
{% endfor %}

{% if dbaas %}
{% set dbs_to_not_delete = ['default', 'system'] + ch.databases %}
remove_deleted_databases:
    cmd.run:
        - name: clickhouse-client -q "SELECT name FROM system.databases" | grep -v -E "^({{ dbs_to_not_delete | join('|') }})\$" | xargs -I 'db_to_drop' clickhouse-client -q "DROP DATABASE db_to_drop"
        - onlyif: clickhouse-client -q "SELECT name FROM system.databases" | grep -q -v -E "^({{ dbs_to_not_delete | join('|') }})\$"
        - require:
            - cmd: clickhouse-server
{% endif %}

{% for database in ch.schemas %}
/usr/local/yandex/clickhouse/{{ database }}.sql:
    file.managed:
        - source: salt://components/clickhouse/databases/{{ database }}.sql
        - makedirs: True
        - require:
            - cmd: clickhouse-server

apply_{{ database }}:
    cmd.wait:
        - name: 'cat /usr/local/yandex/clickhouse/{{ database }}.sql | clickhouse-client -m -n'
        - watch:
            - file: /usr/local/yandex/clickhouse/{{ database }}.sql
{% endfor %}

{{ ch.config_prefix }}/logrotate.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/logrotate.conf
        - mode: 644
        - require:
            - pkg: clickhouse-packages

/etc/cron.d/clickhouse-server-logrotate:
    file.managed:
        - source: salt://{{ slspath }}/conf/logrotate.cron
        - mode: 644
        - require:
            - file: {{ ch.config_prefix }}/logrotate.conf

{% if salt['grains.get']('virtual') == 'lxc'%}
/etc/cron.d/clickhouse_porto_chown:
    file.managed:
        - contents: |
             PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
             @reboot root chown clickhouse.clickhouse /var/lib/clickhouse >/dev/null 2>&1
        - mode: 644
{% endif %}
