{% from "components/clickhouse/map.jinja" import ch with context %}
/etc/pushclient/clickhouse_parser.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/clickhouse_parser.py
        - template: jinja
        - mode: 755
        - makedirs: True
        - require:
            - pkg: pushclient
        - watch_in:
            - service: pushclient

statbox-in-clickhouse-group:
    group.present:
        - name: clickhouse
        - addusers:
            - statbox
        - system: True
        - require:
            - user: statbox-user
        - require_in:
            - service: pushclient

push-client-clickhouse-config:
    file.accumulated:
        - name: push-client-files
        - filename: /etc/pushclient/push-client.conf
        - text: |-
            - log_type: dbaas-int-log
              name: /var/log/clickhouse-server/clickhouse-server.log
              pipe: /etc/pushclient/clickhouse_parser.py -c {{ ch.cluster_id }} 2>> /var/log/statbox/clickhouse_parser.log
        - require:
            - file: /etc/pushclient/clickhouse_parser.py
        - require_in:
            - file: /etc/pushclient/push-client.conf
