{% from slspath ~ "/map.jinja" import ch with context %}

{{ ch.config_prefix }}/ssl:
    file.directory:
        - user: {{ ch.user }}
        - group: {{ ch.user }}
        - makedirs: True
        - mode: 755

{{ ch.config_prefix }}/ssl/server.key:
    file.managed:
        - contents_pillar: cert.key
        - template: jinja
        - user: {{ ch.user }}
        - group: {{ ch.user }}
        - mode: 600
        - require:
            - file: {{ ch.config_prefix }}/ssl
        - require_in:
            - service: clickhouse-server

{{ ch.config_prefix }}/ssl/server.crt:
    file.managed:
        - contents_pillar: cert.crt
        - template: jinja
        - user: {{ ch.user }}
        - group: {{ ch.user }}
        - mode: 600
        - require:
            - file: {{ ch.config_prefix }}/ssl
        - require_in:
            - service: clickhouse-server

{{ ch.ca_bundle }}:
    file.managed:
        - contents_pillar: cert.ca
        - template: jinja
        - user: {{ ch.user }}
        - group: {{ ch.user }}
        - mode: 755
        - require:
            - file: {{ ch.config_prefix }}/ssl
        - require_in:
            - service: clickhouse-server
