{% set log_dir = '/var/log/dbaas-billing' %}
{% set log_path = '{dir}/billing.log'.format(dir=log_dir) %}
{% set fqdn = salt['pillar.get']('data:dbaas:fqdn', salt['grains.get']('fqdn')) %}
{{ log_dir }}:
    file.directory:
        - user: monitor
        - group: monitor

/etc/dbaas-cron/conf.d/billing.conf:
    file.managed:
        - template: jinja
        - source: salt://components/dbaas-cron/conf/task_template.conf
        - mode: '0640'
        - user: root
        - group: monitor
        - context:
            module: billing
            args:
                log_file: {{ log_path }}
                rotate_size: 10485760
                params:
                    fqdn: {{ fqdn }}
                    flavor_id: {{ salt['pillar.get']('data:dbaas:flavor:id') }}
                    flavor_name: {{ salt['pillar.get']('data:dbaas:flavor:name') }}
                    cluster_type: {{ salt['pillar.get']('data:dbaas:cluster_type') }}
                    resource_id: {{ salt['pillar.get']('data:dbaas:vtype_id', '') }}
                    cluster_id: {{ salt['pillar.get']('data:dbaas:cluster_id') }}
                    cluster_name: {{ salt['pillar.get']('data:dbaas:cluster_name') }}
                    project_id: {{ salt['pillar.get']('data:dbaas:project:ext_id') }}
                    type: dbaas
                monrun_checks:
                    ch_ping: 60
        - require:
            - pkg: dbaas-cron
            - file: {{ log_dir }}
        - watch_in:
            - service: dbaas-cron


push-client-billing-config:
    file.accumulated:
        - name: push-client-files
        - filename: /etc/pushclient/push-client.conf
        - text: |
            - log_type: dbaas-billing
              name: {{ log_path }}
        - require:
            - file: {{ log_dir }}
        - require_in:
            - file: /etc/pushclient/push-client.conf
