{% set vtype = salt['pillar.get']('data:dbaas:vtype') %}
{% set is_test = salt['pillar.get']('data:is_test', False) %}

{% if salt['pillar.get']('data:use_unbound_64', False) %}
unbound-config-local64:
    pkg.installed:
        - version: 0.7
{% else %}
local-named-package:
    pkg.installed:
{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
        - name: config-caching-dns
        - version: 1.0-53
    service.running:
        - name: bind9
        - watch:
            - pkg: local-named-package
{% if vtype == 'compute' %}
            - cmd: reconfigure-eth0
{% endif %}
{% else %}
        - name: yamail-config-named
        - version: 1.1-6
{% endif %}

{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
disable-caching-dns-cron:
    file.absent:
        - name: /etc/cron.d/config-caching-dns
        - require:
            - pkg: local-named-package
    service.running:
        - name: cron
        - reload: True
        - watch:
            - file: disable-caching-dns-cron
{% if vtype != 'compute' %}
        - require_in:
            - file: /etc/resolv.conf
{% endif %}
{% endif %}

{% if is_test %}
/etc/resolv.conf:
    file.exists:
        - name: /etc/resolv.conf
{% elif vtype != 'compute' %}
/etc/resolv.conf:
    file.managed:
        - template: jinja
        - source: salt://components/common/conf/etc/resolv.conf
        - mode: 644
        - user: root
        - follow_symlinks: False
        - require:
            - pkg: local-named-package
        - unless:
            - grep NAT64 /etc/resolv.conf
{% else %}
/etc/dhcp/dhclient-enter-hooks.d/dnsupdate:
    file.managed:
        - source: salt://components/common/conf/dnsupdate
        - mode: 755
        - require:
            - pkg: local-named-package

reconfigure-eth0:
    cmd.wait:
        - name: ifdown eth0 && ifup eth0
        - watch:
            - file: /etc/dhcp/dhclient-enter-hooks.d/dnsupdate
{% endif %}
{% endif %}

{% if salt['pillar.get']('data:l3host', False) or salt['pillar.get']('data:ipv6selfdns', False) or vtype == 'compute' %}
selfdns-client-package:
    pkg.installed:
{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
    - name: yandex-selfdns-client
{% else %}
    - name: selfdns-api-client
{% endif %}

/etc/yandex/selfdns-client/default.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/etc/yandex/selfdns-client/default.conf
        - mode: 0644
        - user: root
        - group: selfdns
        - template: jinja
        - require:
            - pkg: selfdns-client-package

/etc/cron.d/yandex-selfdns-client:
    file.managed:
        - source: salt://{{ slspath }}/conf/etc/cron.d/yandex-selfdns-client
        - mode: 644
        - template: jinja
        - require:
            - pkg: selfdns-client-package

{% if salt['pillar.get']('data:second_selfdns', False)  %}
/etc/yandex/selfdns-client/second.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/etc/yandex/selfdns-client/second.conf
        - mode: 644
        - template: jinja
        - require:
            - pkg: selfdns-client-package

/etc/yandex/selfdns-client/plugins/second:
    file.managed:
        - source: salt://{{ slspath }}/conf/etc/yandex/selfdns-client/plugins/second
        - mode: 755
        - template: jinja
        - require:
            - pkg: selfdns-client-package
{% endif %}

/etc/yandex/selfdns-client/plugins/ipv6only:
    file.managed:
        - source: salt://{{ slspath }}/conf/etc/yandex/selfdns-client/plugins/ipv6only
        - mode: 755
        - template: jinja
        - require:
            - pkg: selfdns-client-package
{% endif %}

{% set self_address = {'value': None} %}
{% for interface in salt['grains.get']('ip6_interfaces', []) %}
{% if interface.startswith('eth') %}
{% for addr in salt['grains.get']('ip6_interfaces:' + interface, []) %}
{% if not addr.startswith('fe80') and not addr.startswith('::') and not self_address['value'] %}
{% do self_address.update({'value': addr}) %}
{% endif %}
{% endfor %}
{% endif %}
{% endfor %}

fqdn-in-etc-hosts:
    host.present:
        - name: {{ salt['grains.get']('id') }}
        - ip: {{ self_address['value'] if self_address['value'] else salt['grains.get']('fqdn_ip6') }}
