{% set env = salt['pillar.get']('yandex:environment', 'prod') %}
{% set osrelease = salt['grains.get']('osrelease') %}

include:
{% if env == 'dev' %}
    - components.repositories.apt.common.unstable
    - components.repositories.apt.mail-trusty.unstable
    - components.repositories.apt.yandex-trusty.unstable
    - components.repositories.apt.common.testing
    - components.repositories.apt.mail-trusty.testing
    - components.repositories.apt.yandex-trusty.testing
{% endif %}
    - components.repositories.apt.common.stable
    - components.repositories.apt.mail-trusty.stable
    - components.repositories.apt.yandex-trusty.stable
    - components.repositories.apt.yandex-disk-common.stable
{% if salt['grains.get']('oscodename') == 'trusty' %}
    - components.repositories.apt.yandex-disk-trusty.stable
{% elif salt['grains.get']('oscodename') == 'bionic' %}
    - components.repositories.apt.mdb-bionic.stable
{% endif %}
{% if 'components.postgres' in salt['pillar.get']('data:runlist', []) %}
    - components.repositories.apt.pgdg
{% if env == 'dev' %}
    - components.repositories.apt.yandex-postgresql.unstable
    - components.repositories.apt.yandex-postgresql.testing
{% endif %}
    - components.repositories.apt.yandex-postgresql.stable
{% endif %}
    - components.repositories.apt.search-kernel
    - .pkgs_ubuntu
    - .mail
    - .locale
{% if ( (salt['grains.get']('virtual', '') == 'physical'
         and salt['grains.get']('virtual_subtype', None) != 'Docker' )
       or salt['grains.get']('virtual', '') == 'lxc'
       or salt['grains.get']('manufacturer', '') == 'OpenStack Foundation') %}
    - .hbf
{% endif %}
    - components.atop
    - components.repositories
    - .cores
    - .dns
    - .time
    - .cauth
    - .misc
    - .yandex-environment
    - .dbaas
