{% set env = salt['pillar.get']('yandex:environment', 'prod') %}

include:
    - .dirs

/etc/sudoers:
    file.managed:
        - source: salt://components/common/conf/etc/sudoers
        - mode: 440
        - user: root
        - group: root

# These files are from procps package
# and they are useless in our environment
# for all hosts
/etc/sysctl.d/10-ptrace.conf:
    file.absent

/etc/sysctl.d/10-network-security.conf:
    file.absent

/etc/sysctl.conf:
    file.managed:
        - template: jinja
        - source: salt://components/common/conf/etc/sysctl.conf
        - mode: 644
        - user: root
        - group: root
    cmd.wait:
        - name: 'sysctl -p /etc/sysctl.conf && if ls /etc/sysctl.d/*.conf 2>/dev/null; then sysctl -p /etc/sysctl.d/*.conf; fi'
        - require:
            - file: /etc/sysctl.d/10-ptrace.conf
            - file: /etc/sysctl.d/10-network-security.conf
        - watch:
            - file: /etc/sysctl.conf

/etc/ssh/ssh_config:
    file.managed:
        - source: salt://components/common/conf/etc/ssh/ssh_config
        - mode: 644
        - user: root

/etc/ssh/sshd_config:
    file.managed:
        - source: salt://components/common/conf/etc/ssh/sshd_config
        - mode: 644
        - user: root
        - group: root
        - template: jinja

sshd-service:
    service.running:
        - enable: True
{% if salt['grains.get']('os') == 'Ubuntu' %}
        - name: ssh
{% else %}
        - name: sshd
{% endif %}
        - reload: True
        - watch:
            - file: /etc/ssh/sshd_config

{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
change-sysctl-apply-order:
    file.managed:
        - name: /etc/init/procps.conf
        - source: salt://components/common/conf/etc/init/procps.conf
{% endif %}

root:
    user.present:
        - password: '$6$Sp2n50Keb.umj6Cp$1.PtyDq6V667cjykoTlkarzpPWF5VYLaKjZwrdAtg6K9MbUYN0Sd2WwkABSbQ4tTJv.dRReZYqpDW4KfpkfeM1'

/etc/profile.d/colorize.sh:
    file.managed:
        - source: salt://components/common/conf/etc/profile.d/colorize.sh
        - mode: 644

/etc/profile.d/history.sh:
    file.managed:
        - source: salt://components/common/conf/etc/profile.d/history.sh
        - mode: 644

clean_old_ugly_root_bashrc_hack:
    file.replace:
        - name: /root/.bashrc
        - pattern: 'export PS1="\\\[\\e\[31;1m\\\]\\u@\\\[\\e\[34;1m\\\]\\h\\\[\\033\[00m\\\] \\\[\\033\[01;32m\\\]\\w\\\[\\033\[00m\\\] # "\nexport LANG="en_US\.UTF-8"'
        - repl: ''
        - flags: ['MULTILINE']
        - bufsize: 'file'
        - require_in:
            - file: ugly_root_bashrc_hack

ugly_root_bashrc_hack:
    file.blockreplace:
        - name: /root/.bashrc
        - marker_start: '# BEGIN salt managed zone ugly_root_bashrc_hack'
        - marker_end: '# END salt managed zone ugly_root_bashrc_hack'
        - content: |
            is_pg_running () {
                echo "select 'is_replica', pg_is_in_recovery();" | su - postgres -c "psql -P pager=off -q --no-align --tuples-only --no-readline" 2>/dev/null >/dev/null
            }
            is_pg_replica () {
                echo "select 'is_replica', pg_is_in_recovery();" | su - postgres -c "psql -P pager=off -q --no-align --tuples-only --no-readline" 2>/dev/null | fgrep -q 'is_replica|t'
            }
            is_pg_sync_replica () {
                sudo -u monitor /usr/local/sbin/pg_is_replication_sync.py
            }
            if is_pg_running; then
                if is_pg_replica; then
                    if is_pg_sync_replica; then
                        PG_ROLE=" (\[\033[01;33m\]S\[\033[00m\])"
                    else
                        PG_ROLE=" (\[\033[01;32m\]R\[\033[00m\])"
                    fi
                else
                    PG_ROLE=" (\[\033[31;1m\]M\[\033[00m\])"
                fi
            fi
            export PS1="\[\033]0;\u@\h:\w\007\]\[\e[31;1m\]\u@\[\e[34;1m\]\h\[\033[00m\]$PG_ROLE \[\033[01;32m\]\w\[\033[00m\] # "
            export LANG="en_US.UTF-8"
            alias hs='salt-call --out=highstate --state-out=changes --log-level=quiet state.highstate queue=True'
            alias dstat='dstat -tdrcmnlyp'
            alias monrun='sudo -u monitor monrun'
        - append_if_not_found: True
        - show_changes: True
        - backup: '.salt.bak'

/etc/init/performance-tuner.conf:
    file.managed:
        - source: salt://components/common/conf/performance-tuner.conf
        - mode: 755
        - user: root
        - group: root

ondemand:
    service.disabled

{% if salt['grains.get']('virtual') == 'physical' %}
/usr/local/yandex/cpu-performance-scaling.sh:
    file.managed:
        - source: salt://components/common/conf/cpu-performance-scaling.sh
        - mode: 755
        - user: root
        - group: root
        - makedirs: True

cpu-performance-governor:
    cmd.run:
        - name: /usr/local/yandex/cpu-performance-scaling.sh
        - runas: root
        - require:
            - file: /usr/local/yandex/cpu-performance-scaling.sh
        - onlyif:
            - ls /sys/devices/system/cpu/cpu0/cpufreq
        - unless:
{% for i in range(0, salt['grains.get']('num_cpus')) %}
            - grep performance /sys/devices/system/cpu/cpu{{ i }}/cpufreq/scaling_governor
{% endfor %}
{% endif %}

/etc/cron.weekly/fstrim:
    file.absent

{% if salt['grains.get']('virtual') == 'lxc' %}
/etc/cron.d/ugly-utmp-fix:
    file.managed:
        - source: salt://{{ slspath }}/conf/etc/cron.d/ugly-utmp-fix
        - mode: 644
{% endif %}

{% if salt['grains.get']('virtual') == 'physical' and salt['pillar.get']('data:disable_bitmap', True) %}
{% for md in salt['grains.get']('mdadm', []) %}
disable_internal_bitmap_{{ md }}:
    cmd.run:
        - name: "mdadm --grow --bitmap=none /dev/{{ md }}"
        - onlyif:
            - "mdadm --detail /dev/{{ md }} | fgrep 'Intent Bitmap : Internal'"
            - "fgrep idle /sys/block/{{ md }}/md/sync_action"
{% endfor %}
{% endif %}

{% if salt['grains.get']('os') == 'Ubuntu' and salt['grains.get']('virtual') == 'physical' %}
/etc/default/mdadm:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/mdadm
        - user: root
        - group: root
        - mode: 644
{% endif %}

{% if salt['pillar.get']('data:under_sox_audit', False) == True %}
/root/.ssh/authorized_keys2:
    file.absent:
        - require:
            - pkg: common-packages
{% endif %}

{% if salt['grains.get']('os') == 'Ubuntu' and salt['grains.get']('virtual', 'physical') != 'lxc' and salt['pillar.get']('data:network_autoconf', False) and salt['grains.get']('virtual_subtype', None) != 'Docker' %}
/etc/network/interfaces:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/interfaces
        - mode: 644

/etc/network/projectid:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/projectid
        - mode: 644
{% endif %}

/usr/bin/salt-highstate:
    file.managed:
        - source: salt://components/common/conf/salt-highstate
        - mode: 755

/usr/bin/update-errata:
    file.managed:
        - source: salt://components/common/conf/update-errata
        - mode: 755
