{%
    set pkgs = {
        'kernel': '2.6.32-696.6.3.el6',
        'glibc': '2.12-1.209.el6',
        'cauth-agent': '1.0-8.el6',
        'yamail-config-salt': '7-4e7a18c',
        'yamail-selparse': '0.0.0.6-1.el6',
        'yamail-config-common': '2.5-6',
        'yamail-ssh-keys': '2.0-4',
        'yandex-mail-graphite-sender': '0.1.36-16',
        'skynet-simple-single-bundle': '15.2.23-rebuild2',
        'python-netconfig': '0.42-1',
        'ipmitool': '1.8.11-29.el6_7',
        'gdisk': '0.8.10-1.el6',
        'screen': '4.0.3-18.el6',
        'curl': 'any',
        'lsof': 'any',
        'lsscsi': 'any',
        'mailx': 'any',
        'rhel-colorize': 'any',
        'rsync': 'any',
        'telnet': 'any',
        'tcpdump': 'any',
        'vim-minimal': 'any',
        'virt-what': 'any',
        'wget': 'any',
        'sudo': 'any',
        'dstat': '0.7.0-2.el6',
        'atop': '1.25-1.el6.rf',
        'htop': '0.8.3-2.el6',
        'iotop': '0.3.2-7.el6',
        'iftop': '1.0-0.7.pre4.el6'
    }
%}

common-packages:
    pkg.installed:
        - pkgs:
{% for package, version in pkgs.items() %}
{% if version == 'any' %}
            - {{ package }}
{% else %}
            - {{ package }}: {{ version }}
{% endif %}
{% endfor %}
        - require:
            - file: rhel-default-repos
            - file: /etc/resolv.conf
