{% set osrelease = salt['grains.get']('osrelease') %}

{%
    set pkgs = {
        'apt': '1.2.10',
        'bash-completion': 'any',
        'salt-minion': '2018.3.4-yandex6',
        'salt-common': '2018.3.4-yandex6',
        'config-ssh-banner': 'any',
        'config-yabs-ntp': 'any',
        'curl': 'any',
        'dstat': 'any',
        'file': 'any',
        'htop': 'any',
        'iftop': 'any',
        'iotop': 'any',
        'iptables': 'any',
        'jq': 'any',
        'less': 'any',
        'lsof': 'any',
        'lsscsi': 'any',
        'mailutils': 'any',
        'mawk': '1.9.9.6-yandex1',
        'netcat-openbsd': 'any',
        'ntpdate': 'any',
        'postfix': 'any',
        'psmisc': 'any',
        'rsync': 'any',
        'rsyslog': '7.4.4-1ubuntu2.7',
        'screen': 'any',
        'ssh': 'any',
        'strace': 'any',
        'sudo': '1.8.11-3+yandex1',
        'sysstat': 'any',
        'tcpdump': 'any',
        'telnet': 'any',
        'tmux': 'any',
        'traceroute': 'any',
        'vim': 'any',
        'virt-what': 'any',
        'vlan': 'any',
        'wget': 'any',
        'whois': 'any',
        'yabs-graphite-sender-config-corba': 'any',
        'yandex-archive-keyring': 'any',
        'yandex-dash2bash': 'any',
        'yandex-gosky': '2.2.0',
        'yandex-media-tskv-parser': '0.32',
        'yandex-search-user-monitor': '1.0-45',
        'yandex-netconfig': 'any',
        'zsh': 'any'
    }
%}
{% if salt['pillar.get']('data:dbaas:vtype') != 'compute' %}
    {% set cauth_pkgs = {
        'yandex-cauth': '1.6.2'
        }
    %}
    {% do pkgs.update(cauth_pkgs) %}
{% endif %}

yamail-config-salt:
    pkg.purged:
        - require_in:
            - pkg: common-packages 
    {% set mdb_pkgs = {
        'config-disk-admins-public-keys': '1.0-7315076',
        'diskpg-config-salt': '0.3-7272940'
        }
    %}
    {% do pkgs.update(mdb_pkgs) %}

salt-minion:
  service.dead:
    - enable: False

{% if 'KVM' not in salt['grains.get']('cpu_model') %}
    {% set hwhosts_pkgs = {
        'mcelog': 'any'
        }
    %}

    {% do pkgs.update(hwhosts_pkgs) %}
{% endif %}

{% if salt['grains.get']('virtual', 'physical') != 'lxc' and salt['grains.get']('virtual_subtype', None) != 'Docker' %}
    {% set hwhosts_pkgs = {
        'ethtool': 'any',
        'gdisk': 'any',
        'grub2': 'any',
        'ipmitool': 'any',
        'irqbalance': 'any',
        'smartmontools': 'any',
        'libc6': '2.19-0ubuntu6.*',
        'yandex-coroner': '1.1'
        }
    %}

    {% do pkgs.update(hwhosts_pkgs) %}
{% endif %}

{% if not salt['pillar.get']('data:use_unbound_64', False) %}
    {% set bind9_pkgs = {
        'bind9': 'any'
        }
    %}

    {% do pkgs.update(bind9_pkgs) %}
{% endif %}

apt-get-qq-update:
    cmd.wait:
        - name: apt-get -qq update

common-packages:
    pkg.installed:
        - pkgs:
{% for package, version in pkgs.items() %}
{% if version == 'any' %}
            - {{ package }}
{% else %}
            - {{ package }}: {{ version }}
{% endif %}
{% endfor %}
        - require:
            - pkg: remove-skynet-simple-single-bundle
            - pkg: remove-cauth-client-caching
{% if osrelease == '14.04' %}
            - pkgrepo: mail-trusty-stable-all
            - pkgrepo: mail-trusty-stable-arch
            - pkgrepo: search-kernel-stable-all
            - pkgrepo: search-kernel-stable-arch
{% elif osrelease == '18.04' %}
            - pkgrepo: mdb-bionic-stable-all
            - pkgrepo: mdb-bionic-stable-arch
{% endif %}
{% if 'components.postgres' in salt['pillar.get']('data:runlist', []) %}
            - pkgrepo: pgdg
            - pkgrepo: yandex-postgresql-stable-arch
            - pkgrepo: yandex-postgresql-stable-all
{% endif %}
{% if salt['pillar.get']('data:use_unbound_64', False) %}
            - pkg: unbound-config-local64
{% else %}
{% if salt['pillar.get']('data:dbaas:vtype') != 'compute' %}
            - file: /etc/resolv.conf
{% endif %}
{% endif %}

config-autodetect-active-eth:
    pkg.installed

/etc/apt/apt.conf.d/97allowunauth:
    file.managed:
        - source: salt://components/common/conf/etc/apt/apt.conf.d/97allowunauth
        - mode: 644
        - user: root

remove-skynet-versioned-metapackage:
    pkg.purged:
        - name: yandex-skynet-releaseconf

remove-skynet-simple-single-bundle:
    pkg.purged:
        - name: skynet-simple-single-bundle

remove-cauth-client-caching:
    pkg.purged:
        - pkgs:
            - cauth-client-scripts
            - cauth-client-caching
        - onlyif:
            - "dpkg -l | fgrep -q cauth-client"
