{% if salt['grains.get']('virtual', 'physical') != 'lxc' and not salt['pillar.get']('data:lxc_used', False) and salt['grains.get']('virtual_subtype', None) != 'Docker' %}
local-ntp-config:
{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
    pkg.installed:
        - name: config-yabs-ntp
        - version: 0.1-18
{% else %}
    pkg.installed:
        - name: ntp
        - version: 4.2.6p5-10.el6.1
    file.managed:
        - name: /etc/ntp.conf
        - source: salt://components/common/conf/etc/ntp.conf
        - mode: 644
        - user: root
        - require:
            - pkg: local-ntp-config
{% endif %}

local-ntp-service:
    service.running:
{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
{% if salt['pillar.get']('data:dbaas:vtype', 'porto') == 'compute' %}
        - name: ntp.qemu
{% else %}
        - name: ntp
{% endif %}
        - require:
            - pkg: local-ntp-config
{% else %}
        - name: ntpd
        - require:
            - file: local-ntp-config
{% endif %}
{% endif %}

tzdata:
    pkg.installed:
{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
        - version: 2019a-0ubuntu0.14.04
{% else %}
        - version: 2016j-1.el6
{% endif %}

# http://www.freedesktop.org/software/systemd/man/localtime.html
/etc/localtime:
    file.symlink:
        - target: /usr/share/zoneinfo/Europe/Moscow
        - force: True
        - require:
            - pkg: tzdata
