#!/bin/bash

container=$1
if [ -z "$container" ]; then
    echo "Container name is mandatory."
    exit 1
fi
path=`portoctl get ${container} root`

if [ -d "${path}/bin" ]; then
    echo "${path} is not empty."
    exit 1
fi

tar xf /data/images/mail.tar.xz --numeric-owner -C ${path}

sed -i "s/\.../${container}/g" ${path}/etc/sysconfig/network
ls -1 ${path}/etc/yum.repos.d/*.repo | egrep -v '(mail-c\+\+11|rhel-source)' | xargs sed -i '/enabled/s/0/1/'
hostname -f >${path}/etc/dom0hostname
echo ${container} > ${path}/etc/hostname
echo -n > ${path}/etc/mdadm.conf
portoctl exec packages command="yum -y install selfdns-api-client-0.2.7-3yandex.el6.x86_64 yamail-ssh-keys virt-what tcpdump mc" root="${path}"
rsync -a /etc/yandex/selfdns-client/default.conf ${path}/etc/yandex/selfdns-client/default.conf
