#!/bin/bash

container=$1
if [ -z "$container" ]; then
    echo "Container name is mandatory."
    exit 1
fi
path=`portoctl get ${container} root`

if [ -d "${path}/bin" ]; then
    echo "${path} is not empty."
    exit 1
fi

tar xjf /data/images/bionic.tar.bz2 --numeric-owner -C ${path}

echo "deb http://mirror.yandex.ru/ubuntu bionic main restricted universe multiverse" >${path}/etc/apt/sources.list
echo "deb http://mirror.yandex.ru/ubuntu bionic-security main restricted universe multiverse" >>${path}/etc/apt/sources.list
echo "deb http://mirror.yandex.ru/ubuntu bionic-updates main restricted universe multiverse" >>${path}/etc/apt/sources.list
portoctl exec packages command="apt-get -qq update" root="${path}"
portoctl exec upgrade command="export DEBIAN_FRONTEND=noninteractive; apt-get -y upgrade" root="${path}"
#cp /etc/apt/sources.list.d/common-stable.list ${path}/etc/apt/sources.list.d/
cat <<EOF >> ${path}/etc/apt/sources.list.d/mdb-bionic-stable.list
deb http://dist.yandex.ru/mdb-bionic stable/all/
deb http://dist.yandex.ru/mdb-bionic stable/\$(ARCH)/
EOF

mkdir -p ${path}/opt/yandex/
cp /opt/yandex/allCAs.pem ${path}/opt/yandex/

portoctl exec locale command="locale-gen en_US.UTF-8" root="${path}"
portoctl exec packages command="apt-get -qq update" root="${path}"
portoctl exec packages command="apt-get -y install yandex-archive-keyring" root="${path}"
portoctl exec packages command="apt-get -qq update" root="${path}"
portoctl exec packages command="apt-get -y install virt-what tcpdump" root="${path}"
portoctl exec packages command="apt-get -y install salt-common=2018.3.3+ds-2+yandex0 salt-minion=2018.3.3+ds-2+yandex0 mdb-config-salt=10-61faa13 yandex-selfdns-client mdb-ssh-keys yandex-default-locale-en" root="${path}"
portoctl exec packages command="apt-get -y install config-caching-dns=1.0-12" root="${path}" resolv_conf=""
sed -i ${path}/lib/init/fstab -e 's/^/#/'

rsync -a /etc/yandex/selfdns-client/default.conf ${path}/etc/yandex/selfdns-client/default.conf
portoctl exec selfdns command="chown root:selfdns /etc/yandex/selfdns-client/default.conf" root="${path}"
hostname -f >${path}/etc/dom0hostname

echo "net.ipv6.conf.all.forwarding = 1" >${path}/etc/sysctl.d/30-net-porto.conf
echo "net.ipv6.conf.all.proxy_ndp = 1" >>${path}/etc/sysctl.d/30-net-porto.conf
