{% set osrelease = salt['grains.get']('osrelease') %}
{% if osrelease == '14.04' %}
{%   set porto_version = '4.12.20' %}
{% elif osrelease == '18.04' %}
{%   set porto_version = '4.18.9' %}
{% endif %}

porto-group:
    group.present:
        - name: porto

yandex-porto:
    pkg.installed:
        - version: {{ porto_version }}
        - require:
            - group: porto-group
        - prereq_in:
            - cmd: repositories-ready
{% if osrelease != '14.04' %}
    module.wait:
        - name: service.systemctl_reload
        - require:
            - pkg: yandex-porto
        - require_in:
            - service: yandex-porto
    service.running:
        - enable: True
        - watch:
            - pkg: yandex-porto

/etc/init.d/yandex-porto:
    file.absent:
        - require:
            - pkg: yandex-porto
        - require_in:
            - service: yandex-porto

/etc/init/yandex-porto.conf:
    file.absent:
        - require:
            - pkg: yandex-porto
        - require_in:
            - service: yandex-porto
{% endif %}

porto-packages:
    pkg.installed:
        - pkgs:
            - python-portopy: {{ porto_version }}
{% if osrelease == '14.04' %}
            - python-central
{% endif %}
            - python-protobuf
            - debootstrap
            - python-requests
            - yandex-internal-root-ca
            - yandex-netconfig
            - lldpd   # required by yandex-netconfig MDB-1937
            - ndisc6  # required by yandex-netconfig MDB-1937
        - prereq_in:
            - cmd: repositories-ready
        - require:
            - group: porto-group
            - pkg: yandex-porto

/usr/local/yandex/porto:
    file.recurse:
        - source: salt://{{ slspath }}/bootstrap
        - user: root
        - group: root
        - dir_mode: 755
        - file_mode: 755
        - template: jinja
        - makedirs: True
        - clean: True

/etc/portod.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/portod.conf
        - mode: 644

/etc/sysctl.d/30-net-porto.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/sysctl-porto.conf
        - mode: 644
    cmd.wait:
        - name: sysctl -p /etc/sysctl.d/30-net-porto.conf
        - watch:
            - file: /etc/sysctl.d/30-net-porto.conf

/etc/sysctl.d/40-postgres.conf:
    file.managed:
        - template: jinja
        - source: salt://components/postgres/conf/sysctl-postgres.conf
        - mode: 644
    cmd.wait:
        - name: sysctl -p /etc/sysctl.d/40-postgres.conf
        - watch:
            - file: /etc/sysctl.d/40-postgres.conf

/etc/rc.local:
    file.managed:
        - source: salt://{{ slspath }}/conf/rc.local
        - user: root
        - group: root
        - mode: 0755

{% set thp_file = '/sys/kernel/mm/transparent_hugepage/enabled' %}

disable_THP:
    cmd.run:
        - name: 'echo never > {{ thp_file }}'
        - unless:
            - "fgrep '[never]' {{ thp_file }}"

{% set kernel_modules = salt['pillar.get']('data:kernel_modules', ['ip_tables', 'ip6_tables']) %}

/etc/modules:
    file.append:
        - text:
{% for module in kernel_modules %}
            - {{ module }}
{% endfor %}

/etc/sudoers.d/monitor_dom0porto:
    file.managed:
        - source: salt://{{ slspath }}/conf/monitor_dom0porto.sudoers
        - mode: 440

/etc/cron.d/dom0hostname:
    file.managed:
        - source: salt://{{ slspath }}/conf/dom0hostname.cron.d
        - mode: 644

/etc/cron.d/yasmagent_restart:
    file.managed:
        - source: salt://{{ slspath }}/conf/yasmagent_restart.cron.d
        - mode: 644

/etc/cron.d/remove_old_backups:
    file.managed:
        - source: salt://{{ slspath }}/conf/remove_old_backups.cron.d
        - mode: 644

# {% if salt['pillar.get']('data:config:dbm_heartbeat_override', False) %}
# /etc/dbm_heartbeat_override.json:
#     file.managed:
#         - source: salt://{{ slspath }}/conf/heartbeat_override.json
#         - template: jinja
#         - mode: 600
# {% endif %}

# /etc/cron.d/heartbeat:
#     file.managed:
#         - source: salt://{{ slspath }}/conf/heartbeat.cron.d
#         - mode: 644

# /etc/cron.yandex/heartbeat.py:
#     file.managed:
#         - source: salt://{{ slspath }}/conf/heartbeat.py
#         - template: jinja
#         - mode: 700

/usr/local/yandex/remove_old_backups.sh:
    file.managed:
        - source: salt://{{ slspath }}/conf/remove_old_backups.sh
        - template: jinja
        - mode: 744

/usr/local/yandex/dom0_mdbuild.sh:
    file.managed:
        - source: salt://{{ slspath }}/conf/dom0_mdbuild.sh
        - mode: 700

build_raw_disks_arrays:
    cmd.run:
        - name: /usr/local/yandex/dom0_mdbuild.sh
        - require:
            - file: /usr/local/yandex/dom0_mdbuild.sh
        - onlyif:
            - /usr/local/yandex/dom0_mdbuild.sh check

/usr/sbin/move_container.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/move_container.py
        - mode: 755

# /root/.mdb_move_container.conf:
#     file.managed:
#         - source: salt://{{ slspath }}/conf/move_container.conf
#         - template: jinja
#         - mode: 600

/data:
    mount.mounted:
        - device: {{ salt['pillar.get']('data:array_for_data', '/dev/md/2') }}
        - fstype: ext4
        - mkmnt: True
        - opts:
            - defaults
            - noatime
        - onlyif:
            - fgrep {{ salt['pillar.get']('data:array_for_data', '/dev/md/2') }} /etc/mdadm/mdadm.conf
        - require_in:
            - pkg: porto-packages

{% set slow_array = salt['pillar.get']('data:array_for_sata', '') %}
{% if slow_array != '' %}
/slow:
    mount.mounted:
        - device: {{ slow_array }}
        - fstype: ext4
        - mkmnt: True
        - opts:
            - defaults
            - noatime
        - onlyif:
            - fgrep {{ slow_array }} /etc/mdadm/mdadm.conf
    file.symlink:
        - name: /data/slow
        - target: /slow
        - require:
            - mount: /data
        - require_in:
            - pkg: porto-packages
{% endif %}

/etc/default/acct:
    file.managed:
        - source: salt://{{ slspath }}/conf/acct
        - user: root
        - group: root
        - mode: 0644

python-netconfig-purge:
    pkg.purged:
        - pkgs:
            - python-netconfig
