#!/bin/sh

set -e

echo "Starting $(date)"
for i in "pg postgresql" "pg-bionic postgresql-bionic" "ch clickhouse" "mongodb mongodb" "zk zookeeper" "redis redis" "mysql mysql" "mysql-bionic mysql-bionic"
do
    short="$(echo "$i" | cut -d' ' -f1)"
    long="$(echo "$i" | cut -d' ' -f2)"
    latest="$(/usr/bin/s3cmd ls s3://dbaas-images/${long}/ | grep '.gz' | sort -k2M -k1 -k3 | tail -n 1 | awk '{print $1, $3, $4};')"
    latest_date="$(echo "${latest}" | awk '{print $1};')"
    latest_size="$(echo "${latest}" | awk '{print $2};')"
    latest_path="$(echo "${latest}" | awk '{print $3};')"
    target_path="/data/images/${short}-template-${latest_date}.tar.gz"
    skip_download=0

    if [ -f "${target_path}" ]
    then
        target_size="$(stat -c %s "${target_path}")"
        if [ "${target_size}" = "${latest_size}" ]
        then
            echo "Download will be skipped"
            skip_download=1
        fi
    fi

    if [ "${skip_download}" = 0 ]
    then
        s3cmd get --force "${latest_path}" "${target_path}"
    fi

    cur_link="$(ls -la /data/images/${short}-template.tar.gz | awk '{print $NF};')"

    if [ "${cur_link}" != "${target_path}" ]
    then
        echo "Updating link"
        ln -sf "${target_path}" "/data/images/${short}-template.tar.gz"
        rm -f "${cur_link}"
    fi
done
