#!/bin/bash


used_blacklist="$(blkid -o device -u raid /dev/sd*)"
size_blacklist=""
for dev in $(ls /dev/sd* | grep -v -E '[0-9]+')
do
    size=$(blockdev --getsize64 "${dev}")
    if [ "$?" != "0" ]
    then
        echo "Filtering out ${dev}: Unable to get size"
        size_blacklist="$dev $size_blacklist"
        continue
    fi
    if [ "$size" -lt 10995116277760 ]
    then
        size_blacklist="$dev $size_blacklist"
    fi
done

blacklist="$(echo $used_blacklist $size_blacklist | xargs -n 1 echo | sort -u | grep -v -E '[0-9]+' | xargs echo | sed -e 's/\ /\[0-9\]\*\$\|/g' -e 's/$/\[0-9\]\*\$/g')"

if [ "$1" = "check" ]
then
    unused=$(ls /dev/sd* | grep -cv -E "$blacklist")
    if [ "$unused" -gt 1 ]
    then
        exit 0
    else
        exit 1
    fi
fi

set -xe
target="$(( "$(ls /dev/md* | sed 's/\/dev\/md//g' | sort -g | tail -n1)" + 1 ))"

if [ ${target} -lt 100 ]
then
    target=100
fi

while read -r pair
do
    if [ "$(echo ${pair} | wc -w)" != "2" ]
    then
        break
    fi

    list=""
    for dev in $pair
    do
        parted "${dev}" mklabel gpt
        parted "${dev}" mkpart primary 0% 100%
        list="${dev}1 $list"
    done

    yes | mdadm --create "/dev/md${target}" --force --level=1 --raid-devices=2 $list
    mkfs.ext4 "/dev/md${target}"
    dev_id="$(blkid -s UUID -o export /dev/md${target} | grep UUID)"
    path="/disks/$(echo ${dev_id} | cut -d= -f2)"
    mkdir -p "$path"
    echo "$dev_id $path ext4 defaults,noatime 0 0" >> /etc/fstab
    mount "${path}"
    cat <<EOF > /etc/mdadm/mdadm.conf
CREATE owner=root group=disk mode=0660 auto=yes
HOMEHOST <system>
MAILADDR root
$(mdadm --examine --scan)
EOF
    update-initramfs -u -k all
    target=$(( target + 1 ))
done < <(ls /dev/sd* | grep -v -E "$blacklist" | xargs -L 2 echo)
