#!/bin/bash

# By default 30 days
THREASHOLD={{ salt['pillar.get']('data:config:old_backups_threashold', '2592000') }} # in seconds

backups=$(find /data -maxdepth 3 -type d -regex '/data.*yandex\.net.*[0-9]+.bak' -regextype posix-egrep)

for backup in $backups
do
    ts=$(echo "$backup" | awk -F\. '{print $(NF-1)}')
    age=$(echo "$(date +%s) - $ts" | bc)
    if [ "$age" -gt "$THREASHOLD" ]; then
        echo "Removing old backup $backup"
        rm -rf "$backup"
    fi
done

empty_dirs=$(find /data -maxdepth 3 -type d -empty -regex '/data.*/[a-z0-9.-]+\.yandex\.net$' -regextype posix-egrep)

for empty_dir in $empty_dirs
do
    echo "Removing empty dir $empty_dir"
    rm -rf "$empty_dir"
done

# By default 3 days
RAW_DISK_THREASHOLD={{ salt['pillar.get']('data:config:disk_old_backups_threashold', '259200') }} # in seconds

disk_backups=$(find /disks -maxdepth 2 -type d -regex '/disks.*/[a-z0-9.-]+\.yandex\.net\.[0-9]+.bak' -regextype posix-egrep)

for backup in $disk_backups
do
    ts=$(echo "$backup" | awk -F\. '{print $(NF-1)}')
    age=$(echo "$(date +%s) - $ts" | bc)
    if [ "$age" -gt "$RAW_DISK_THREASHOLD" ]; then
        echo "Removing old backup $backup"
        rm -rf "$backup"
    fi
done
