{% set huge_pages = [0] %}
{% for container in salt['pillar.get']('data:porto', {}).keys() %}
{% set limit_bytes = salt['pillar.get']('data:porto:' + container + ':container_options:hugetlb_limit', 0)|int %}
{% do huge_pages.append(huge_pages.pop() + (limit_bytes / 2048 / 1024)|int) %}
{% if not salt['pillar.get']('target-container') or container == salt['pillar.get']('target-container') %}
{% if salt['pillar.get']('data:porto:' + container + ':container_options:pending_delete', False) %}

destroy_{{ container }}:
    porto_container.absent:
        - name: {{ container }}

{% for volume in salt['pillar.get']('data:porto:' + container + ':volumes', []) %}
{% if volume.pending_backup %}
backup_{{ volume.dom0_path }}:
    cmd.run:
        - name: "mv {{ volume.dom0_path }} {{ volume.dom0_path}}.$(date +%s).bak"
        - require:
            - porto_container: destroy_{{ container }}
        - onlyif:
            - ls {{ volume.dom0_path }}
{% else %}
rm_{{ volume.dom0_path }}:
    cmd.run:
        - name: "rm -rf {{ volume.dom0_path }}"
        - require:
            - porto_container: destroy_{{ container }}
        - require_in:
            - cmd: drop_{{ container }}_from_db
        - onlyif:
            - ls {{ volume.dom0_path }}
{% endif %}
{% endfor %}

{% set token = salt['pillar.get']('data:porto:' + container + ':container_options:delete_token') %}
{% set base_url = salt['pillar.get']('data:config:dbm_url') %}
{% set url = base_url + '/api/v2/dom0/delete-report/' + container %}

drop_{{ container }}_from_db:
    cmd.run:
        - name: |
            curl -s -X POST '{{ url }}' -H 'Accept: application/json' -H 'Content-Type: application/json' -d '{"token": "{{ token }}"}'
        - require:
            - porto_container: destroy_{{ container }}
{% else %}

{% set paths = [] %}
{% set bind_list = [] %}

{% for volume in salt['pillar.get']('data:porto:' + container + ':volumes', []) %}

{{ volume.dom0_path }}:
    file.directory:
{% if '/var/lib/' in volume.path %}
{% else %}
        - user: root
        - group: root
{% endif %}
        - makedirs: True
    porto_volume.present:
{% for option, value in volume.items() %}
{% if option not in ('dom0_path', 'path', 'pending_backup') %}
        - {{ option }}: '{{ value }}'
{% endif %}
{% endfor %}
        - require:
            - file: {{ volume.dom0_path }}

{% if volume.path == '/' %}
{% do paths.append(volume.dom0_path) %}
{% else %}
{% if volume.read_only %}
{% set type = 'ro' %}
{% else %}
{% set type = 'rw' %}
{% endif %}
{% do bind_list.append([volume.dom0_path, volume.path, type]|join(' ')) %}
{% endif %}

{% endfor %}

{% set path = paths[0] %}

create_{{ container }}:
    porto_container.present:
        - name: {{ container }}
        - storage: {{ path }}
        - bind: '{{ bind_list|join(';') }}'
{% for option, value in salt['pillar.get']('data:porto:' + container + ':container_options', {}).items() %}
{% if option|string not in ['secrets', 'bootstrap_cmd', 'pending_delete', 'delete_token'] %}
        - {{ option }}: '{{ value }}'
{% endif %}
{% endfor %}
        - require:
{% for volume in salt['pillar.get']('data:porto:' + container + ':volumes', []) %}
            - porto_volume: {{ volume.dom0_path }}
{% endfor %}


{% for volume in salt['pillar.get']('data:porto:' + container + ':volumes', []) %}
link_{{ volume.dom0_path }}_to_{{ container }}:
    porto_volume.linked:
        - storage: {{ volume.dom0_path }}
        - container: {{ container }}
        - require:
            - porto_volume: {{ volume.dom0_path }}
            - porto_container: create_{{ container }}

unlink_{{ volume.dom0_path }}_from_root_container:
    porto_volume.unlinked:
        - storage: {{ volume.dom0_path }}
        - container: /
        - require:
            - porto_volume: link_{{ volume.dom0_path }}_to_{{ container }}
            - porto_container: create_{{ container }}
{% endfor %}

bootstrap_{{ container }}:
    cmd.run:
        - name: {{ salt['pillar.get']('data:porto:' + container + ':container_options:bootstrap_cmd', '/usr/local/yandex/porto/mail_trusty.sh') + ' ' + container }}
        - require:
            - porto_volume: link_{{ path }}_to_{{ container }}
        - unless:
            - ls {{ path }}/bin/ls

start_{{ container }}:
    porto_container.running:
        - name: {{ container }}
        - require:
            - cmd: bootstrap_{{ container }}

{% for secret, options in salt['pillar.get']('data:porto:' + container + ':container_options:secrets', {}).items() %}
{{ container }}_secret_{{ secret }}:
    file.managed:
        - name: {{ path + secret }}
        - mode: {{ options.get('mode', '0600') }}
        - makedirs: True
        - contents_pillar: {{ 'data:porto:' + container + ':container_options:secrets:' + secret + ':content' }}
        - require:
            - cmd: bootstrap_{{ container }}
        - require_in:
            - porto_container: start_{{ container }}
{% endfor %}

add_{{ container }}_to_dns:
    cmd.run:
        - name: 'echo "su -s /bin/bash selfdns -c \"/usr/bin/selfdns-client --debug\"" | portoctl shell {{ container }}'
        - runas: root
        - require:
            - porto_container: start_{{ container }}
        - unless:
            - 'host {{ container }}'

{% endif %}
{% endif %}
{% endfor %}

{% if salt['pillar.get']('data:sysctl:vm.nr_hugepages', -1) != -1 %}
{%     do huge_pages.pop() %}
{%     do huge_pages.append(salt['pillar.get']('data:sysctl:vm.nr_hugepages')) %}
{% endif %}
{% set total_ram_pages = salt['grains.get']('mem_total', 128000) / 2 %}
{% set total_huge_pages = (huge_pages[0] + 0.01 * total_ram_pages)|int %}

vm.nr_hugepages:
    sysctl.present:
        - value: {{ total_huge_pages }}
        - config: /etc/sysctl.d/hugepages.conf
