/data/images/mail.tar.xz:
    file.managed:
        - makedirs: True
        - source: http://dist.yandex.ru/images/mail/mail-proto-rhel6.tar.xz
        - source_hash: http://dist.yandex.ru/images/mail/mail-proto-rhel6.tar.xz.md5

/data/images/trusty.tar.bz2:
    file.managed:
        - makedirs: True
        - source: http://dist.yandex.ru/images/ubuntu/ubuntu-14.04.tar.bz2
        - source_hash: http://dist.yandex.ru/images/ubuntu/ubuntu-14.04.tar.bz2.md5

/data/images/bionic.tar.bz2:
    file.managed:
        - makedirs: True
        - source: http://dist.yandex.ru/images/ubuntu/ubuntu-18.04.tar.bz2
        - source_hash: http://dist.yandex.ru/images/ubuntu/ubuntu-18.04.tar.bz2.md5

{% if salt['pillar.get']('data:dom0porto:use_dbaas_dom0_images', False) %}
s3cmd:
    pkg.installed

/root/.s3cfg:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath + '/conf/s3cfg' }}
        - mode: '0600'
        - require:
            - pkg: s3cmd

/etc/cron.d/dom0-images-sync:
    file.managed:
        - source: salt://{{ slspath + '/conf/dom0_images_sync.cron' }}
        - require:
            - file: /root/.s3cfg

/etc/logrotate.d/dom0-images-sync:
    file.managed:
        - source: salt://{{ slspath + '/conf/dom0_images_sync.logrotate' }}
        - require:
            - file: /root/.s3cfg

/etc/cron.yandex/dom0-images-sync.sh:
    file.managed:
        - source: salt://{{ slspath + '/conf/dom0_images_sync.sh' }}
        - mode: '0755'
        - require:
            - file: /root/.s3cfg
{% endif %}
