{% set osrelease = salt['grains.get']('osrelease') %}
yasmagent-packages:
    pkg.installed:
        - pkgs:
            - yandex-yasmagent: 2.400-20200121
            - python-psycopg2
{% if osrelease == '14.04' %}
            - python-pymongo: 3.1.1-yandex1
            - python-bson: 3.1.1-yandex1
{% elif osrelease == '18.04' %}
            - python-pymongo
            - python-bson
{% endif %}
        - prereq_in:
            - cmd: repositories-ready

yasmagent-init:
    file.managed:
        - name: /etc/init.d/yasmagent
        - template: jinja
        - source: salt://components/postgres/conf/yasm-agent.ubuntu.init
        - mode: 755
        - require:
            - pkg: yasmagent-packages

{# override yasm watchdog cause MDB-3430 #}
yasmagent-watchdog:
    file.managed:
        - name: /usr/local/yasmagent/watchdog.sh
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasmagent_watchdog.sh
        - mode: 755
        - require:
            - pkg: yasmagent-packages

yasmagent-default-config:
    file.managed:
        - name: /etc/default/yasmagent
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasmagent.default
        - mode: 644

yasmagent-instance-getter:
    file.managed:
        - name: /usr/local/yasmagent/dom0porto_getter.py
        - template: jinja
        - source: salt://{{ slspath }}/conf/dom0porto_getter.py
        - mode: 755
        - require:
            - pkg: yasmagent-packages

/etc/server_info.json:
    file.managed:
        - user: root
        - group: root
        - mode: 644
        - source: salt://{{ slspath }}/conf/server_info.py
        - template: py

yasmagent-restart:
    service:
        - running
        - enable: true
        - name: yasmagent
        - watch:
            - pkg: yasmagent-packages
            - file: yasmagent-instance-getter
            - file: yasmagent-default-config
            - file: yasmagent-init
